/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aop.internal.intercepted;

import io.micronaut.aop.InterceptedMethod;
import io.micronaut.aop.InterceptorKind;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.aop.internal.intercepted.CompletionStageInterceptedMethod;
import io.micronaut.aop.internal.intercepted.KotlinInterceptedMethod;
import io.micronaut.aop.internal.intercepted.PublisherInterceptedMethod;
import io.micronaut.aop.internal.intercepted.SynchronousInterceptedMethod;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.ReturnType;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;

@Internal
public class InterceptedMethodUtil {
    public static InterceptedMethod of(MethodInvocationContext<?, ?> context) {
        if (context.isSuspend()) {
            KotlinInterceptedMethod kotlinInterceptedMethod = KotlinInterceptedMethod.of(context);
            if (kotlinInterceptedMethod != null) {
                return kotlinInterceptedMethod;
            }
            return new SynchronousInterceptedMethod(context);
        }
        ReturnType returnType = context.getReturnType();
        Class returnTypeClass = returnType.getType();
        if (returnTypeClass == Void.TYPE || returnTypeClass == String.class) {
            return new SynchronousInterceptedMethod(context);
        }
        if (CompletionStage.class.isAssignableFrom(returnTypeClass) || Future.class.isAssignableFrom(returnTypeClass)) {
            return new CompletionStageInterceptedMethod(context);
        }
        if (PublisherInterceptedMethod.isConvertibleToPublisher(returnTypeClass)) {
            return new PublisherInterceptedMethod(context);
        }
        return new SynchronousInterceptedMethod(context);
    }

    public static AnnotationValue<?>[] resolveInterceptorBinding(AnnotationMetadata annotationMetadata, InterceptorKind interceptorKind) {
        AnnotationValue interceptorBindings = annotationMetadata.getAnnotation("io.micronaut.aop.InterceptorBindingDefinitions");
        if (interceptorBindings != null) {
            return (AnnotationValue[])interceptorBindings.getAnnotations("value").stream().filter(av -> {
                InterceptorKind kind = av.enumValue("kind", InterceptorKind.class).orElse(InterceptorKind.AROUND);
                return kind == interceptorKind;
            }).toArray(AnnotationValue[]::new);
        }
        return AnnotationUtil.ZERO_ANNOTATION_VALUES;
    }
}

