/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aop.chain;

import io.micronaut.aop.Adapter;
import io.micronaut.aop.Around;
import io.micronaut.aop.Interceptor;
import io.micronaut.aop.InterceptorBinding;
import io.micronaut.aop.InterceptorKind;
import io.micronaut.aop.Introduction;
import io.micronaut.aop.InvocationContext;
import io.micronaut.aop.chain.AdapterIntroduction;
import io.micronaut.aop.exceptions.UnimplementedAdviceException;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.EnvironmentConfigurable;
import io.micronaut.context.annotation.Type;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableArgumentValue;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.qualifiers.InterceptorBindingQualifier;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class InterceptorChain<B, R>
implements InvocationContext<B, R> {
    protected static final Logger LOG = LoggerFactory.getLogger(InterceptorChain.class);
    private static final Interceptor[] ZERO_INTERCEPTORS = new Interceptor[0];
    protected final Interceptor<B, R>[] interceptors;
    protected final B target;
    protected final ExecutableMethod<B, R> executionHandle;
    protected final Object[] originalParameters;
    protected MutableConvertibleValues<Object> attributes;
    protected Map<String, MutableArgumentValue<?>> parameters;
    protected final int interceptorCount;
    protected int index = 0;

    public InterceptorChain(Interceptor<B, R>[] interceptors, B target, ExecutableMethod<B, R> method, Object ... originalParameters) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Intercepted method [{}] invocation on target: {}", (Object)method, (Object)target);
        }
        this.target = target;
        this.originalParameters = originalParameters;
        this.executionHandle = method;
        this.interceptors = interceptors;
        this.interceptorCount = interceptors.length;
    }

    @Override
    public Object[] getParameterValues() {
        return this.originalParameters;
    }

    @Override
    public AnnotationMetadata getAnnotationMetadata() {
        return this.executionHandle.getAnnotationMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableConvertibleValues<Object> getAttributes() {
        MutableConvertibleValues<Object> attributes = this.attributes;
        if (attributes == null) {
            InterceptorChain interceptorChain = this;
            synchronized (interceptorChain) {
                attributes = this.attributes;
                if (attributes == null) {
                    this.attributes = attributes = MutableConvertibleValues.of(new ConcurrentHashMap(5));
                }
            }
        }
        return attributes;
    }

    @Override
    public Argument[] getArguments() {
        return this.executionHandle.getArguments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, MutableArgumentValue<?>> getParameters() {
        Map<String, MutableArgumentValue<?>> parameters = this.parameters;
        if (parameters == null) {
            InterceptorChain interceptorChain = this;
            synchronized (interceptorChain) {
                parameters = this.parameters;
                if (parameters == null) {
                    Argument[] arguments = this.executionHandle.getArguments();
                    parameters = new LinkedHashMap(arguments.length);
                    int i = 0;
                    while (i < arguments.length) {
                        final Argument argument = this.executionHandle.getArguments()[i];
                        final int finalIndex = i++;
                        parameters.put(argument.getName(), new MutableArgumentValue<Object>(){

                            @Override
                            public AnnotationMetadata getAnnotationMetadata() {
                                return argument.getAnnotationMetadata();
                            }

                            @Override
                            public Optional<Argument<?>> getFirstTypeVariable() {
                                return argument.getFirstTypeVariable();
                            }

                            @Override
                            public Argument[] getTypeParameters() {
                                return argument.getTypeParameters();
                            }

                            @Override
                            public Map<String, Argument<?>> getTypeVariables() {
                                return argument.getTypeVariables();
                            }

                            @Override
                            @NonNull
                            public String getName() {
                                return argument.getName();
                            }

                            @Override
                            @NonNull
                            public Class<Object> getType() {
                                return argument.getType();
                            }

                            @Override
                            public boolean equalsType(Argument<?> other) {
                                return argument.equalsType(other);
                            }

                            @Override
                            public int typeHashCode() {
                                return argument.typeHashCode();
                            }

                            @Override
                            public Object getValue() {
                                return InterceptorChain.this.originalParameters[finalIndex];
                            }

                            @Override
                            public void setValue(Object value) {
                                InterceptorChain.this.originalParameters[finalIndex] = value;
                            }
                        });
                    }
                    parameters = Collections.unmodifiableMap(parameters);
                    this.parameters = parameters;
                }
            }
        }
        return parameters;
    }

    @Override
    public R invoke(B instance, Object ... arguments) {
        return this.proceed();
    }

    @Override
    public B getTarget() {
        return this.target;
    }

    @Override
    public R proceed() throws RuntimeException {
        if (this.interceptorCount == 0 || this.index == this.interceptorCount) {
            try {
                return this.executionHandle.invoke(this.target, this.getParameterValues());
            }
            catch (AbstractMethodError e) {
                throw new UnimplementedAdviceException(this.executionHandle);
            }
        }
        Interceptor<B, R> interceptor = this.interceptors[this.index++];
        if (LOG.isTraceEnabled()) {
            LOG.trace("Proceeded to next interceptor [{}] in chain for method invocation: {}", (Object)interceptor, (Object)this.executionHandle);
        }
        return interceptor.intercept(this);
    }

    @Override
    public R proceed(Interceptor from) throws RuntimeException {
        for (int i = 0; i < this.interceptors.length; ++i) {
            Interceptor<B, R> interceptor = this.interceptors[i];
            if (interceptor != from) continue;
            this.index = i + 1;
            return this.proceed();
        }
        throw new IllegalArgumentException("Argument [" + from + "] is not within the interceptor chain");
    }

    @Internal
    public static Interceptor[] resolveAroundInterceptors(@Nullable BeanContext beanContext, ExecutableMethod<?, ?> method, List<BeanRegistration<Interceptor<?, ?>>> interceptors) {
        return InterceptorChain.resolveInterceptors(beanContext, method, interceptors, InterceptorKind.AROUND);
    }

    @Internal
    public static Interceptor[] resolveIntroductionInterceptors(@Nullable BeanContext beanContext, ExecutableMethod<?, ?> method, List<BeanRegistration<Interceptor<?, ?>>> interceptors) {
        Interceptor[] introductionInterceptors = InterceptorChain.resolveInterceptors(beanContext, method, interceptors, InterceptorKind.INTRODUCTION);
        Interceptor[] aroundInterceptors = InterceptorChain.resolveInterceptors(beanContext, method, interceptors, InterceptorKind.AROUND);
        return ArrayUtils.concat(aroundInterceptors, introductionInterceptors);
    }

    @Internal
    @Deprecated
    public static Interceptor[] resolveAroundInterceptors(@Nullable BeanContext beanContext, ExecutableMethod<?, ?> method, Interceptor ... interceptors) {
        InterceptorChain.instrumentAnnotationMetadata(beanContext, method);
        return InterceptorChain.resolveInterceptorsInternal(method, Around.class, interceptors, beanContext != null ? beanContext.getClassLoader() : InterceptorChain.class.getClassLoader());
    }

    @Internal
    @Deprecated
    public static Interceptor[] resolveIntroductionInterceptors(@Nullable BeanContext beanContext, ExecutableMethod<?, ?> method, Interceptor ... interceptors) {
        InterceptorChain.instrumentAnnotationMetadata(beanContext, method);
        Interceptor[] introductionInterceptors = InterceptorChain.resolveInterceptorsInternal(method, Introduction.class, interceptors, beanContext != null ? beanContext.getClassLoader() : InterceptorChain.class.getClassLoader());
        if (introductionInterceptors.length == 0) {
            if (method.hasStereotype((Class<Annotation>)Adapter.class)) {
                introductionInterceptors = new Interceptor[]{new AdapterIntroduction(beanContext, method)};
            } else {
                throw new IllegalStateException("At least one @Introduction method interceptor required, but missing. Check if your @Introduction stereotype annotation is marked with @Retention(RUNTIME) and @Type(..) with the interceptor type. Otherwise do not load @Introduction beans if their interceptor definitions are missing!");
            }
        }
        Interceptor[] aroundInterceptors = InterceptorChain.resolveAroundInterceptors(beanContext, method, interceptors);
        return ArrayUtils.concat(aroundInterceptors, introductionInterceptors);
    }

    @NonNull
    private static Interceptor[] resolveInterceptors(BeanContext beanContext, ExecutableMethod<?, ?> method, List<BeanRegistration<Interceptor<?, ?>>> interceptors, InterceptorKind interceptorKind) {
        if (interceptors.isEmpty()) {
            if (interceptorKind == InterceptorKind.INTRODUCTION) {
                if (method.hasStereotype((Class<Annotation>)Adapter.class)) {
                    return new Interceptor[]{new AdapterIntroduction(beanContext, method)};
                }
                throw new IllegalStateException("At least one @Introduction method interceptor required, but missing. Check if your @Introduction stereotype annotation is marked with @Retention(RUNTIME) and @Type(..) with the interceptor type. Otherwise do not load @Introduction beans if their interceptor definitions are missing!");
            }
            return ZERO_INTERCEPTORS;
        }
        InterceptorChain.instrumentAnnotationMetadata(beanContext, method);
        List applicableBindings = method.getAnnotationValuesByType(InterceptorBinding.class).stream().filter(ann -> ann.enumValue("kind", InterceptorKind.class).orElse(InterceptorKind.AROUND) == interceptorKind).collect(Collectors.toList());
        Interceptor[] resolvedInterceptors = (Interceptor[])interceptors.stream().filter(beanRegistration -> applicableBindings.stream().anyMatch(annotationValue -> {
            boolean isApplicableByType = annotationValue.classValue("interceptorType").map(t -> t.isInstance(beanRegistration.getBean())).orElse(false);
            boolean isApplicationByBinding = annotationValue.stringValue().map(annotationName -> InterceptorBindingQualifier.resolveInterceptorValues(beanRegistration.getBeanDefinition().getAnnotationMetadata()).contains(annotationName)).orElse(false);
            return isApplicableByType || isApplicationByBinding;
        })).sorted(OrderUtil.COMPARATOR).map(BeanRegistration::getBean).toArray(Interceptor[]::new);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Resolved {} {} interceptors out of a possible {} for method: {} - {}", new Object[]{resolvedInterceptors.length, interceptorKind, interceptors.size(), method.getDeclaringType(), method.getDescription(true)});
            for (int i = 0; i < resolvedInterceptors.length; ++i) {
                Interceptor resolvedInterceptor = resolvedInterceptors[i];
                LOG.trace("Interceptor {} - {}", (Object)i, (Object)resolvedInterceptor);
            }
        }
        return resolvedInterceptors;
    }

    private static void instrumentAnnotationMetadata(BeanContext beanContext, ExecutableMethod<?, ?> method) {
        EnvironmentConfigurable m;
        if (beanContext instanceof ApplicationContext && method instanceof EnvironmentConfigurable && (m = (EnvironmentConfigurable)((Object)method)).hasPropertyExpressions()) {
            m.configure(((ApplicationContext)beanContext).getEnvironment());
        }
    }

    private static Interceptor[] resolveInterceptorsInternal(ExecutableMethod<?, ?> method, Class<? extends Annotation> annotationType, Interceptor[] interceptors, @NonNull ClassLoader classLoader) {
        List<Class<? extends Annotation>> annotations = method.getAnnotationTypesByStereotype(annotationType, classLoader);
        HashSet<Class> applicableClasses = new HashSet<Class>();
        for (Class<? extends Annotation> aClass : annotations) {
            Type typeAnn;
            if (annotationType == Around.class && aClass.getAnnotation(Around.class) == null && aClass.getAnnotation(Introduction.class) != null || annotationType == Introduction.class && aClass.getAnnotation(Introduction.class) == null && aClass.getAnnotation(Around.class) != null || (typeAnn = aClass.getAnnotation(Type.class)) == null) continue;
            applicableClasses.addAll(Arrays.asList(typeAnn.value()));
        }
        Ordered[] interceptorArray = (Interceptor[])Arrays.stream(interceptors).filter(i -> applicableClasses.stream().anyMatch(t -> t.isInstance(i))).toArray(Interceptor[]::new);
        OrderUtil.sort(interceptorArray);
        return interceptorArray;
    }
}

