/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet.dsp.impl;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.web.servlet.dsp.impl.InterpretContext;
import org.zkoss.web.servlet.dsp.impl.Node;
import org.zkoss.web.servlet.dsp.impl.ParseContext;
import org.zkoss.xel.Expression;
import org.zkoss.xel.XelContext;
import org.zkoss.xel.XelException;

class XelNode
extends Node {
    private static final Logger log = LoggerFactory.getLogger(XelNode.class);
    private final Expression _expr;

    XelNode(String expr, ParseContext ctx) throws XelException {
        this._expr = ctx.getExpressionFactory().parseExpression((XelContext)ctx, expr, String.class);
    }

    @Override
    void interpret(InterpretContext ic) throws IOException {
        try {
            String result = (String)this._expr.evaluate(ic.xelc);
            if (result != null) {
                ic.dc.getOut().write(result);
            }
        }
        catch (XelException ex) {
            log.error("", (Throwable)ex);
            throw ex;
        }
    }

    @Override
    void addChild(Node node) {
        throw new IllegalStateException("No child allowed");
    }

    public String toString() {
        return "EL[" + this._expr + ']';
    }
}

