/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.fn;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.zkoss.lang.Library;
import org.zkoss.lang.Strings;
import org.zkoss.web.fn.ThemeFns;
import org.zkoss.web.servlet.dsp.DspException;
import org.zkoss.web.servlet.dsp.action.ActionContext;
import org.zkoss.web.servlet.http.Encodes;
import org.zkoss.web.servlet.xel.RequestContext;
import org.zkoss.web.servlet.xel.RequestContexts;
import org.zkoss.web.theme.StandardTheme;
import org.zkoss.web.theme.Theme;

public class ServletFns {
    private static final String THEME_FOLDER_ROOT = "org.zkoss.theme.folder.root";

    protected ServletFns() {
    }

    public static String encodeURL(String uri) throws ServletException {
        return Encodes.encodeURL(ServletFns.getCurrentServletContext(), ServletFns.getCurrentRequest(), ServletFns.getCurrentResponse(), uri);
    }

    public static final String encodeThemeURL(String s) throws ServletException {
        if (s == null) {
            return null;
        }
        return ServletFns.encodeURL(ServletFns.resolveThemeURL(s));
    }

    public static final String resolveThemeURL(String url) {
        if (url == null) {
            return null;
        }
        String themeName = ThemeFns.getCurrentTheme();
        String prefix = Library.getProperty((String)THEME_FOLDER_ROOT, (String)"theme");
        String resolved = null;
        if (Strings.isBlank((String)themeName) || "iceblue".equals(themeName)) {
            resolved = url;
        } else {
            Theme theme = ThemeFns.getThemeRegistry().getTheme(themeName);
            if (theme instanceof StandardTheme) {
                resolved = ((StandardTheme)theme).getOrigin() == StandardTheme.ThemeOrigin.JAR ? url.replaceFirst("~./", "~./" + themeName + "/") : url.replaceFirst("~./", "/" + prefix + "/" + themeName + "/");
            }
        }
        return resolved;
    }

    public static RequestContext getCurrentContext() {
        return RequestContexts.getCurrent();
    }

    public static Writer getCurrentOut() throws IOException {
        return ServletFns.getCurrentContext().getOut();
    }

    public static ServletContext getCurrentServletContext() {
        return ServletFns.getCurrentContext().getServletContext();
    }

    public static ServletRequest getCurrentRequest() {
        return ServletFns.getCurrentContext().getRequest();
    }

    public static ServletResponse getCurrentResponse() {
        return ServletFns.getCurrentContext().getResponse();
    }

    public static void render(ActionContext ac) throws DspException, IOException {
        ac.renderFragment(null);
    }
}

