/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zel.impl.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Date;
import java.util.LinkedList;
import org.zkoss.zel.impl.util.Cache;
import org.zkoss.zel.impl.util.FastReadCache;
import org.zkoss.zel.impl.util.Objects;
import org.zkoss.zel.impl.util.Primitives;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Classes {
    private static final Object NOT_FOUND = new Object();
    private static Cache<AOInfo, Object> _closms = new FastReadCache<AOInfo, Object>(600, 14400000);
    public static final int B_GET = 0;
    public static final int B_SET = 1;
    public static final int B_PUBLIC_ONLY = 2;
    public static final int B_METHOD_ONLY = 4;
    private static final int B_BY_SUBCLASS = 4096;
    private static Cache<AOInfo, AccessibleObject> _acsos = new FastReadCache<AOInfo, AccessibleObject>(600, 14400000);

    public static final Object newInstance(Class<?> cls, Class<?>[] argTypes, Object[] args) throws NoSuchMethodException, InstantiationException, InvocationTargetException, IllegalAccessException {
        return cls.getConstructor(argTypes).newInstance(args);
    }

    public static final Object newInstance(Class<?> cls, Object[] args) throws NoSuchMethodException, InstantiationException, InvocationTargetException, IllegalAccessException {
        if (args == null || args.length == 0) {
            return cls.newInstance();
        }
        Constructor[] cxs = cls.getConstructors();
        Constructor cx = Classes.match(cxs, args, false);
        if (cx == null) {
            cx = Classes.match(cxs, args, true);
        }
        if (cx != null) {
            return cx.newInstance(args);
        }
        throw new NoSuchMethodException(cls.getName() + ": no constructor for " + Objects.toString(args));
    }

    private static Constructor match(Constructor[] cxs, Object[] args, boolean loosely) {
        for (int j = 0; j < cxs.length; ++j) {
            if (!Classes.matched(cxs[j].getParameterTypes(), args, loosely)) continue;
            return cxs[j];
        }
        return null;
    }

    private static Method match(Class<?> cls, String name, Object[] args, boolean loosely) {
        Method[] ms = cls.getMethods();
        for (int j = 0; j < ms.length; ++j) {
            if (!ms[j].getName().equals(name) || !Classes.matched(ms[j].getParameterTypes(), args, loosely)) continue;
            if (Modifier.isPublic(ms[j].getDeclaringClass().getModifiers())) {
                return ms[j];
            }
            try {
                return Classes.getMethodInPublic(cls, ms[j].getName(), ms[j].getParameterTypes());
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean matched(Class[] types, Object[] args, boolean loosely) {
        if (types.length == args.length) {
            Object[] argcvt = loosely ? new Object[args.length] : args;
            boolean cvted = false;
            int k = args.length;
            while (true) {
                if (--k < 0) {
                    if (cvted) {
                        System.arraycopy(argcvt, 0, args, 0, args.length);
                    }
                    return true;
                }
                Object arg = argcvt[k] = args[k];
                Class type = types[k];
                if (arg == null) {
                    if (!type.isPrimitive()) continue;
                    break;
                }
                if (type.isInstance(arg) || type.isPrimitive() && Primitives.toWrapper(type).isInstance(arg)) continue;
                if (!loosely) break;
                argcvt[k] = Classes.looselyCast(type, arg);
                if (argcvt[k] == null) break;
                cvted = true;
            }
        }
        return false;
    }

    private static Object looselyCast(Class type, Object arg) {
        if (type == Integer.class || type == Integer.TYPE) {
            if (arg instanceof Number) {
                return new Integer(((Number)arg).intValue());
            }
        } else if (type == Long.class || type == Long.TYPE) {
            if (arg instanceof Number) {
                return new Long(((Number)arg).longValue());
            }
        } else if (type == Double.class || type == Double.TYPE) {
            if (arg instanceof Number) {
                return new Double(((Number)arg).doubleValue());
            }
        } else if (type == Short.class || type == Short.TYPE) {
            if (arg instanceof Number) {
                return new Short(((Number)arg).shortValue());
            }
        } else if (type == Float.class || type == Float.TYPE) {
            if (arg instanceof Number) {
                return new Float(((Number)arg).floatValue());
            }
        } else if ((type == Byte.class || type == Byte.TYPE) && arg instanceof Number) {
            return new Byte(((Number)arg).byteValue());
        }
        return null;
    }

    public static final Object newInstance(String clsName, Class<?>[] argTypes, Object[] args) throws NoSuchMethodException, InstantiationException, InvocationTargetException, ClassNotFoundException, IllegalAccessException {
        return Classes.newInstance(Class.forName(clsName), argTypes, args);
    }

    public static final Object newInstanceByThread(String clsName, Class<?>[] argTypes, Object[] args) throws NoSuchMethodException, InstantiationException, InvocationTargetException, ClassNotFoundException, IllegalAccessException {
        return Classes.newInstance(Classes.forNameByThread(clsName), argTypes, args);
    }

    public static final Object newInstanceByThread(String clsName) throws NoSuchMethodException, InstantiationException, InvocationTargetException, ClassNotFoundException, IllegalAccessException {
        return Classes.newInstance(Classes.forNameByThread(clsName), null, null);
    }

    public static final Class<?> forNameByThread(String clsName) throws ClassNotFoundException {
        Class cls = Primitives.toClass(clsName = Classes.toInternalForm(clsName));
        if (cls != null) {
            return cls;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            try {
                return Class.forName(clsName, true, cl);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return Class.forName(clsName);
    }

    public static final boolean existsByThread(String clsnm) {
        try {
            Classes.forNameByThread(clsnm);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static final String toInternalForm(String clsName) {
        int k = clsName.indexOf(91);
        if (k <= 0) {
            return clsName;
        }
        String elm = clsName.substring(0, k).trim();
        if (elm.length() == 0) {
            throw new IllegalArgumentException("Not a legal class name: \"" + clsName + '\"');
        }
        boolean leftb = false;
        String stub = clsName.substring(k);
        StringBuffer sb = new StringBuffer(128);
        for (int j = 0; j < stub.length(); ++j) {
            char ch = stub.charAt(j);
            if (ch == '[') {
                if (leftb) {
                    throw new IllegalArgumentException("Not a legal class name: \"" + clsName + '\"');
                }
                leftb = true;
                sb.append('[');
                continue;
            }
            if (ch != ']') continue;
            if (!leftb) {
                throw new IllegalArgumentException("Not a legal class name: \"" + clsName + '\"');
            }
            leftb = false;
        }
        if (leftb) {
            throw new IllegalArgumentException("Not a legal class name: \"" + clsName + '\"');
        }
        char code = Primitives.getNotation(elm);
        if (code != '\u0000') {
            sb.append(code);
        } else {
            sb.append('L').append(elm).append(';');
        }
        return sb.toString();
    }

    public static Class<?> getTopmostInterface(Class<?> cls, Class<?> subIF) {
        if (cls.isInterface()) {
            return subIF.isAssignableFrom(cls) ? cls : null;
        }
        while (cls != null) {
            Class<?>[] ifs = cls.getInterfaces();
            for (int j = 0; j < ifs.length; ++j) {
                if (!subIF.isAssignableFrom(ifs[j])) continue;
                return ifs[j];
            }
            cls = cls.getSuperclass();
        }
        return null;
    }

    public static Class<?>[] getAllInterfaces(Class<?> cls) {
        LinkedList l = new LinkedList();
        while (cls != null) {
            Class<?>[] ifs = cls.getInterfaces();
            for (int j = 0; j < ifs.length; ++j) {
                l.add(ifs[j]);
            }
            cls = cls.getSuperclass();
        }
        int sz = l.size();
        return l.toArray(new Class[sz]);
    }

    public static final boolean containsMethod(Class<?> cls, String name, Class<?>[] paramTypes) {
        try {
            cls.getMethod(name, paramTypes);
            return true;
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
    }

    public static final String correctFieldName(String name) {
        int j = name.indexOf(45);
        if (j < 0) {
            return name;
        }
        StringBuffer sb = new StringBuffer(name);
        do {
            sb.deleteCharAt(j);
            if (sb.length() == j) {
                return sb.toString();
            }
            sb.setCharAt(j, Character.toUpperCase(sb.charAt(j)));
        } while ((j = sb.indexOf("-", j)) >= 0);
        return sb.toString();
    }

    public static final String toMethodName(String attrName, String prefix) {
        if (prefix.length() == 0) {
            return attrName;
        }
        StringBuffer sb = new StringBuffer(prefix);
        char[] buf = attrName.toCharArray();
        buf[0] = Character.toUpperCase(buf[0]);
        return sb.append(buf).toString();
    }

    public static final boolean isAttribute(String methodName) {
        int j;
        int len = methodName.length();
        if (len < 2) {
            return false;
        }
        switch (methodName.charAt(0)) {
            case 'g': 
            case 's': {
                if (len < 3 || methodName.charAt(1) != 'e' || methodName.charAt(2) != 't') {
                    return false;
                }
                j = 3;
                break;
            }
            case 'i': {
                if (methodName.charAt(1) != 's') {
                    return false;
                }
                j = 2;
                break;
            }
            default: {
                return false;
            }
        }
        return j == len || Character.isUpperCase(methodName.charAt(j));
    }

    public static final String toAttributeName(String methodName) {
        int j;
        int len = methodName.length();
        if (len < 2) {
            return null;
        }
        switch (methodName.charAt(0)) {
            case 'g': 
            case 's': {
                if (len < 3 || methodName.charAt(1) != 'e' || methodName.charAt(2) != 't') {
                    return null;
                }
                j = 3;
                break;
            }
            case 'i': {
                if (methodName.charAt(1) != 's') {
                    return null;
                }
                j = 2;
                break;
            }
            default: {
                return null;
            }
        }
        if (j == len || Character.isUpperCase(methodName.charAt(j))) {
            char[] buf = new char[len - j];
            if (buf.length > 0) {
                methodName.getChars(j, len, buf, 0);
                buf[0] = Character.toLowerCase(buf[0]);
            }
            return new String(buf);
        }
        return null;
    }

    public static final Method getMethodInPublic(Class<?> cls, String name, Class<?>[] argTypes) throws NoSuchMethodException {
        Method m = cls.getMethod(name, argTypes);
        if (Modifier.isPublic(m.getDeclaringClass().getModifiers())) {
            return m;
        }
        Class<?>[] clses = cls.getInterfaces();
        for (int j = 0; j < clses.length; ++j) {
            try {
                return Classes.getMethodInPublic(clses[j], name, argTypes);
            }
            catch (NoSuchMethodException ex) {
                continue;
            }
        }
        Class<?> basecls = cls.getSuperclass();
        if (basecls != null) {
            try {
                return Classes.getMethodInPublic(basecls, name, argTypes);
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        throw Classes.newNoSuchMethodException(cls, name, argTypes);
    }

    private static NoSuchMethodException newNoSuchMethodException(Class cls, String name, Object[] args) {
        return new NoSuchMethodException(cls.getName() + ": no method called " + name + " for " + Objects.toString(args));
    }

    public static final Method getMethodByObject(Class<?> cls, String name, Object[] args) throws NoSuchMethodException {
        if (args == null) {
            return Classes.getMethodInPublic(cls, name, null);
        }
        Method mtd = Classes.match(cls, name, args, false);
        if (mtd == null && (mtd = Classes.match(cls, name, args, true)) == null) {
            throw Classes.newNoSuchMethodException(cls, name, args);
        }
        return mtd;
    }

    public static final Method getCloseMethod(Class<?> cls, String name, Class<?>[] argTypes) throws NoSuchMethodException {
        if (argTypes == null || argTypes.length == 0) {
            return Classes.getMethodInPublic(cls, name, null);
        }
        AOInfo aoi = new AOInfo(cls, name, argTypes, 0);
        Object m = _closms.get(aoi);
        if (m == NOT_FOUND) {
            throw Classes.newNoSuchMethodException(cls, name, argTypes);
        }
        if (m != null) {
            return (Method)m;
        }
        try {
            m = Classes.myGetCloseMethod(cls, name, argTypes, false);
        }
        catch (NoSuchMethodException ex) {
            _closms.put(aoi, NOT_FOUND);
            throw ex;
        }
        _closms.put(aoi, m);
        return (Method)m;
    }

    public static final Method getCloseMethodBySubclass(Class<?> cls, String name, Class<?>[] argTypes) throws NoSuchMethodException {
        if (argTypes == null || argTypes.length == 0) {
            return Classes.getMethodInPublic(cls, name, null);
        }
        AOInfo aoi = new AOInfo(cls, name, argTypes, 4096);
        Object m = _closms.get(aoi);
        if (m == NOT_FOUND) {
            throw Classes.newNoSuchMethodException(cls, name, argTypes);
        }
        if (m != null) {
            return (Method)m;
        }
        try {
            m = Classes.myGetCloseMethod(cls, name, argTypes, true);
        }
        catch (NoSuchMethodException ex) {
            _closms.put(aoi, NOT_FOUND);
            throw ex;
        }
        _closms.put(aoi, m);
        return (Method)m;
    }

    private static final Method myGetCloseMethod(Class<?> cls, String name, Class<?>[] argTypes, boolean bySubclass) throws NoSuchMethodException {
        int j = 0;
        while (true) {
            if (j == argTypes.length) {
                try {
                    return Classes.getMethodInPublic(cls, name, argTypes);
                }
                catch (NoSuchMethodException ex) {
                    break;
                }
            }
            if (argTypes[j] == null) break;
            ++j;
        }
        Method[] ms = cls.getMethods();
        block5: for (int j2 = 0; j2 < ms.length; ++j2) {
            Class<?>[] mTypes;
            if (!ms[j2].getName().equals(name) || (mTypes = ms[j2].getParameterTypes()).length != argTypes.length) continue;
            boolean bPublic = Modifier.isPublic(ms[j2].getDeclaringClass().getModifiers());
            int k = 0;
            while (true) {
                Class c;
                if (k == argTypes.length) {
                    if (bPublic) {
                        return ms[j2];
                    }
                    try {
                        return Classes.getMethodInPublic(cls, ms[j2].getName(), ms[j2].getParameterTypes());
                    }
                    catch (NoSuchMethodException ex) {
                        continue block5;
                    }
                }
                Class<?> argType = argTypes[k];
                Class<?> mType = mTypes[k];
                if (!(argType == null || !bySubclass && mType.isAssignableFrom(argType) || bySubclass && argType.isAssignableFrom(mType) || (c = Primitives.toPrimitive(argType)) != null && c.equals(mType))) continue block5;
                ++k;
            }
        }
        throw Classes.newNoSuchMethodException(cls, name, argTypes);
    }

    public static final Method[] getCloseMethods(Class<?> cls, String name, Class<?>[] argTypes) {
        if (argTypes == null || argTypes.length == 0) {
            try {
                return new Method[]{Classes.getMethodInPublic(cls, name, null)};
            }
            catch (NoSuchMethodException ex) {
                return new Method[0];
            }
        }
        return Classes.myGetCloseMethods(cls, name, argTypes, false);
    }

    public static final Method[] getCloseMethodsBySubclass(Class<?> cls, String name, Class<?>[] argTypes) {
        if (argTypes == null || argTypes.length == 0) {
            return Classes.getCloseMethods(cls, name, null);
        }
        return Classes.myGetCloseMethods(cls, name, argTypes, true);
    }

    private static final Method[] myGetCloseMethods(Class<?> cls, String name, Class<?>[] argTypes, boolean bySubclass) {
        LinkedList<Method> mtds = new LinkedList<Method>();
        Method[] ms = cls.getMethods();
        block2: for (int j = 0; j < ms.length; ++j) {
            Class<?>[] mTypes;
            if (!ms[j].getName().equals(name) || (mTypes = ms[j].getParameterTypes()).length != argTypes.length) continue;
            boolean bPublic = Modifier.isPublic(ms[j].getDeclaringClass().getModifiers());
            int k = 0;
            while (true) {
                Class c;
                if (k == argTypes.length) {
                    if (bPublic) {
                        mtds.add(ms[j]);
                        continue block2;
                    }
                    try {
                        mtds.add(Classes.getMethodInPublic(cls, ms[j].getName(), ms[j].getParameterTypes()));
                    }
                    catch (NoSuchMethodException ex) {}
                    continue block2;
                }
                Class<?> argType = argTypes[k];
                Class<?> mType = mTypes[k];
                if (!(argType == null || !bySubclass && mType.isAssignableFrom(argType) || bySubclass && argType.isAssignableFrom(mType) || (c = Primitives.toPrimitive(argType)) != null && c.equals(mType))) continue block2;
                ++k;
            }
        }
        return mtds.toArray(new Method[mtds.size()]);
    }

    public static final AccessibleObject getAccessibleObject(Class<?> cls, String name, Class<?>[] argTypes, int flags) throws NoSuchMethodException {
        AOInfo aoi = new AOInfo(cls, name, argTypes, flags);
        AccessibleObject ao = _acsos.get(aoi);
        if (ao != null) {
            return ao;
        }
        ao = Classes.myGetAcsObj(cls, name, argTypes, flags);
        _acsos.put(aoi, ao);
        return ao;
    }

    private static final AccessibleObject myGetAcsObj(Class<?> cls, String name, Class<?>[] argTypes, int flags) throws NoSuchMethodException {
        String decoratedName = Classes.toMethodName(name, (flags & 1) != 0 ? "set" : "get");
        try {
            return Classes.getCloseMethod(cls, decoratedName, argTypes);
        }
        catch (NoSuchMethodException ex) {
            String isMethodName = null;
            if ((flags & 1) == 0) {
                try {
                    isMethodName = Classes.toMethodName(name, "is");
                    return Classes.getCloseMethod(cls, isMethodName, argTypes);
                }
                catch (NoSuchMethodException ex2) {
                    // empty catch block
                }
            }
            try {
                return Classes.getCloseMethod(cls, name, argTypes);
            }
            catch (NoSuchMethodException ex3) {
                block22: {
                    if ((flags & 6) == 6) {
                        throw ex3;
                    }
                    if ((flags & 2) == 0) {
                        try {
                            return Classes.getAnyMethod(cls, decoratedName, argTypes);
                        }
                        catch (NoSuchMethodException ex4) {
                            if ((flags & 1) == 0) {
                                try {
                                    return Classes.getAnyMethod(cls, isMethodName, argTypes);
                                }
                                catch (NoSuchMethodException ex5) {
                                    // empty catch block
                                }
                            }
                            try {
                                return Classes.getAnyMethod(cls, name, argTypes);
                            }
                            catch (NoSuchMethodException ex6) {
                                if ((flags & 4) == 0) break block22;
                                throw ex6;
                            }
                        }
                    }
                }
                if (argTypes != null && argTypes.length > 1) {
                    throw Classes.newNoSuchMethodException(cls, name, argTypes);
                }
                try {
                    return cls.getField(name);
                }
                catch (NoSuchFieldException ex7) {
                    try {
                        if ((flags & 2) != 0) {
                            throw ex7;
                        }
                        return Classes.getAnyField(cls, name);
                    }
                    catch (NoSuchFieldException ex8) {
                        throw Classes.newNoSuchMethodException(cls, name, argTypes);
                    }
                }
            }
        }
    }

    public static final Method getAnyMethod(Class<?> cls, String name, Class<?>[] argTypes) throws NoSuchMethodException {
        try {
            return cls.getDeclaredMethod(name, argTypes);
        }
        catch (NoSuchMethodException ex) {
            Class<?>[] clses = cls.getInterfaces();
            for (int j = 0; j < clses.length; ++j) {
                try {
                    return Classes.getAnyMethod(clses[j], name, argTypes);
                }
                catch (NoSuchMethodException e2) {
                    continue;
                }
            }
            if ((cls = cls.getSuperclass()) == null) {
                throw ex;
            }
            return Classes.getAnyMethod(cls, name, argTypes);
        }
    }

    public static final Field getAnyField(Class<?> cls, String name) throws NoSuchFieldException {
        while (true) {
            try {
                return cls.getDeclaredField(name);
            }
            catch (NoSuchFieldException ex) {
                if ((cls = cls.getSuperclass()) != null) continue;
                throw ex;
            }
            break;
        }
    }

    public static final Class<?>[] getSuperClasses(Class<?> cls, Class<?>[] clsToCheck) {
        if (clsToCheck != null) {
            int[] hits = new int[clsToCheck.length];
            int no = 0;
            for (int j = 0; j < clsToCheck.length; ++j) {
                if (!clsToCheck[j].isAssignableFrom(cls)) continue;
                hits[no++] = j;
            }
            if (no != clsToCheck.length) {
                if (no == 0) {
                    return null;
                }
                Class[] exc = new Class[no];
                for (int j = 0; j < no; ++j) {
                    exc[j] = clsToCheck[hits[j]];
                }
                return exc;
            }
        }
        return clsToCheck;
    }

    public static final boolean isPrimitiveWrapper(Class<?> cls) {
        return Objects.equals(cls.getPackage(), Boolean.class.getPackage()) && (cls.equals(Boolean.class) || cls.equals(Byte.class) || cls.equals(Character.class) || cls.equals(Double.class) || cls.equals(Float.class) || cls.equals(Integer.class) || cls.equals(Long.class) || cls.equals(Short.class));
    }

    public static final boolean isNumeric(Class<?> cls, boolean extend) {
        if (cls.isPrimitive()) {
            return extend || !cls.equals(Character.TYPE) && !cls.equals(Boolean.TYPE);
        }
        if (Number.class.isAssignableFrom(cls)) {
            return true;
        }
        return extend && (cls.equals(Date.class) || cls.equals(Boolean.class) || cls.equals(Character.class));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AOInfo {
        private Class<?> cls;
        private String name;
        private Class<?>[] argTypes;
        private int flags;

        private AOInfo(Class<?> cls, String name, Class<?>[] argTypes, int flags) {
            this.cls = cls;
            this.name = name;
            this.argTypes = argTypes;
            this.flags = flags;
        }

        public int hashCode() {
            return this.cls.hashCode() + this.name.hashCode() + this.flags;
        }

        public boolean equals(Object o) {
            int len2;
            if (this == o) {
                return true;
            }
            if (!(o instanceof AOInfo)) {
                return false;
            }
            AOInfo aoi = (AOInfo)o;
            int len = this.argTypes != null ? this.argTypes.length : 0;
            int n = len2 = aoi.argTypes != null ? aoi.argTypes.length : 0;
            if (len != len2) {
                return false;
            }
            if (this.flags != aoi.flags || !this.cls.equals(aoi.cls) || !this.name.equals(aoi.name)) {
                return false;
            }
            for (int j = 0; j < len; ++j) {
                if (Objects.equals(this.argTypes[j], aoi.argTypes[j])) continue;
                return false;
            }
            return true;
        }
    }

    public static class MethodInfo {
        public String returnType;
        public String method;
        public String[] argTypes;
        public String[] argNames;
        public String throwsEx;

        protected MethodInfo(String r, String m, String[] argTs, String[] argNs, String tEx) {
            this.returnType = r;
            this.method = m;
            this.argTypes = argTs;
            this.argNames = argNs;
            this.throwsEx = tEx;
        }
    }
}

