/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.maven;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.zeroturnaround.javarebel.maven.RebelXmlBuilder;
import org.zeroturnaround.javarebel.maven.model.RebelClasspath;
import org.zeroturnaround.javarebel.maven.model.RebelClasspathResource;
import org.zeroturnaround.javarebel.maven.model.RebelResource;
import org.zeroturnaround.javarebel.maven.model.RebelWar;
import org.zeroturnaround.javarebel.maven.model.RebelWeb;
import org.zeroturnaround.javarebel.maven.model.RebelWebResource;
import org.zeroturnaround.javarebel.maven.util.SystemUtils;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, threadSafe=true)
public class GenerateRebelMojo
extends AbstractMojo {
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private static final Set<String> JAR_PACKAGING = new HashSet<String>();
    private static final Set<String> WAR_PACKAGING = new HashSet<String>();
    private static final String POM_PACKAGING = "pom";
    public static final String CHARTSET_UTF8 = "UTF-8";
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="project.packaging", required=true)
    private String packaging;
    @Parameter(property="project.build.outputDirectory", required=true)
    private File classesDirectory;
    @Parameter(defaultValue="${basedir}/src/main/webapp", required=true)
    private File warSourceDirectory;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}", required=true)
    private File webappDirectory;
    @Parameter
    private RebelClasspath classpath;
    @Parameter
    private RebelWar war;
    @Parameter
    private RebelWeb web;
    @Parameter
    private String rootPath;
    @Parameter
    private String relativePath;
    @Parameter
    private String rootRelativePath;
    @Parameter(property="rebel.xml.dir", defaultValue="${project.build.outputDirectory}", required=true)
    private File rebelXmlDirectory;
    @Parameter(property="rebel.generate.show", defaultValue="false")
    private boolean showGenerated;
    @Parameter(defaultValue="false")
    private boolean addResourcesDirToRebelXml;
    @Parameter(defaultValue="false")
    private boolean alwaysGenerate;
    @Parameter(defaultValue="true")
    private boolean generateDefaultWeb;
    @Parameter(defaultValue="true")
    private boolean generateDefaultClasspath;
    @Parameter(defaultValue="true")
    private boolean generateDefaultElements;
    @Parameter(defaultValue="false")
    private boolean generateRebelRemote;
    @Parameter(defaultValue="false")
    private boolean skip;
    @Component
    private BuildContext buildContext;
    @Parameter(defaultValue="${mojoExecution}")
    private MojoExecution execution;
    @Parameter(defaultValue="${session}")
    private MavenSession session;
    @Parameter(defaultValue="${project.build.directory}")
    private String projectBuildDir;

    public void execute() throws MojoExecutionException {
        if (this.rootPath == null) {
            this.rootPath = this.project.getBasedir().getAbsolutePath();
            this.relativePath = ".";
        } else if (this.rootRelativePath == null) {
            if (this.relativePath == null) {
                this.relativePath = ".";
            }
        } else {
            try {
                this.relativePath = this.calculateRelativePath(this.calculatePathToRoot(this.findBaseDirOfMainProject(), this.project.getBasedir()), this.rootRelativePath);
                this.getLog().info((CharSequence)("auto-detected relative path to main project : " + this.relativePath));
            }
            catch (IOException ex) {
                this.getLog().debug((CharSequence)"Error during relative path calculation", (Throwable)ex);
                this.getLog().error((CharSequence)"ERROR! Path defined in <rootRelativePath> is not a valid relative path with regard to root module's path. Falling back to absolute paths.");
            }
        }
        try {
            if (this.skip || Boolean.getBoolean("performRelease")) {
                this.getLog().info((CharSequence)"Skipped generating JRebel configuration files.");
                return;
            }
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        if (!this.generateDefaultElements) {
            this.generateDefaultClasspath = false;
            this.generateDefaultWeb = false;
        }
        File rebelXmlFile = new File(this.rebelXmlDirectory, "rebel.xml").getAbsoluteFile();
        File rebelRemoteXmlFile = new File(this.rebelXmlDirectory, "rebel-remote.xml").getAbsoluteFile();
        File pomXmlFile = this.getProject().getFile();
        if (this.generateRebelRemote && (this.alwaysGenerate || !rebelRemoteXmlFile.exists())) {
            this.generateRebelRemoteXmlFile(rebelRemoteXmlFile);
        }
        if (!this.alwaysGenerate && rebelXmlFile.exists() && pomXmlFile.exists() && rebelXmlFile.lastModified() > pomXmlFile.lastModified()) {
            return;
        }
        this.getLog().info((CharSequence)("Processing " + this.getProject().getGroupId() + ":" + this.getProject().getArtifactId() + " with packaging " + this.packaging));
        RebelXmlBuilder builder = null;
        if (WAR_PACKAGING.contains(this.packaging)) {
            builder = this.buildWar();
        } else if (JAR_PACKAGING.contains(this.packaging)) {
            builder = this.buildJar();
        } else if (POM_PACKAGING.equals(this.packaging)) {
            this.getLog().info((CharSequence)"Skipped generating rebel.xml for parent.");
        } else {
            this.getLog().warn((CharSequence)("Unsupported packaging type: " + this.packaging));
        }
        if (builder != null) {
            Writer w;
            if (this.showGenerated) {
                try {
                    w = new StringWriter();
                    try {
                        builder.writeXml(w);
                        this.getLog().info((CharSequence)w.toString());
                    }
                    finally {
                        w.close();
                    }
                }
                catch (IOException e) {
                    this.getLog().debug((CharSequence)"Detected exception during 'showGenerated' : ", (Throwable)e);
                }
            }
            try {
                this.rebelXmlDirectory.mkdirs();
                w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(rebelXmlFile), CHARTSET_UTF8));
                try {
                    builder.writeXml(w);
                }
                finally {
                    w.close();
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed writing rebel.xml", (Exception)e);
            }
            finally {
                if (this.buildContext != null) {
                    this.buildContext.refresh(rebelXmlFile);
                }
            }
        }
    }

    private void generateRebelRemoteXmlFile(File rebelRemoteXmlFile) throws MojoExecutionException {
        Writer w;
        this.getLog().info((CharSequence)("Generating rebel-remote.xml on : " + rebelRemoteXmlFile.getAbsolutePath()));
        if (this.showGenerated) {
            try {
                w = new StringWriter();
                try {
                    this.generateRebelRemoteXml(w);
                    this.getLog().info((CharSequence)w.toString());
                }
                finally {
                    w.close();
                }
            }
            catch (IOException e) {
                this.getLog().debug((CharSequence)"Detected exception during 'showGenerated' : ", (Throwable)e);
            }
        }
        try {
            this.rebelXmlDirectory.mkdirs();
            w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(rebelRemoteXmlFile), CHARTSET_UTF8));
            try {
                this.generateRebelRemoteXml(w);
            }
            finally {
                w.close();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed writing rebel-remote.xml", (Exception)e);
        }
        finally {
            if (this.buildContext != null) {
                this.buildContext.refresh(rebelRemoteXmlFile);
            }
        }
    }

    void generateRebelRemoteXml(Writer w) throws IOException {
        w.write(String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<rebel-remote xmlns=\"http://www.zeroturnaround.com/rebel/remote\">\n    <id>%s</id>\n</rebel-remote>", SystemUtils.ensurePathAndURLSafeName(String.format("%s.%s", this.getProject().getGroupId(), this.getProject().getArtifactId()))));
    }

    private RebelXmlBuilder buildWar() throws MojoExecutionException {
        RebelXmlBuilder builder = this.createXmlBuilder();
        this.buildWeb(builder);
        this.buildClasspath(builder);
        if (this.war != null) {
            this.war.setPath(this.fixFilePath(this.war.getPath()));
            builder.setWar(this.war);
        }
        return builder;
    }

    private RebelXmlBuilder buildJar() throws MojoExecutionException {
        RebelXmlBuilder builder = this.createXmlBuilder();
        this.buildClasspath(builder);
        if (this.web != null && this.web.getResources() != null && this.web.getResources().length != 0) {
            this.generateDefaultWeb = false;
            this.buildWeb(builder);
        }
        return builder;
    }

    private RebelXmlBuilder createXmlBuilder() {
        return new RebelXmlBuilder(this.session.getSystemProperties().getProperty("maven.version"), this.execution.getVersion(), this.projectBuildDir);
    }

    private void buildClasspath(RebelXmlBuilder builder) throws MojoExecutionException {
        RebelClasspathResource[] resources;
        boolean addDefaultAsFirst = true;
        RebelClasspathResource defaultClasspath = null;
        if (this.classpath != null && (resources = this.classpath.getResources()) != null && resources.length > 0) {
            for (RebelClasspathResource r : resources) {
                if (r.isTargetSet()) continue;
                addDefaultAsFirst = false;
                defaultClasspath = r;
                break;
            }
        }
        if (addDefaultAsFirst) {
            this.buildDefaultClasspath(builder, defaultClasspath);
        }
        if (this.classpath != null) {
            builder.setFallbackClasspath(this.classpath.getFallback());
            resources = this.classpath.getResources();
            if (resources != null && resources.length > 0) {
                for (RebelClasspathResource r : resources) {
                    if (r.isTargetSet()) {
                        if (r.getDirectory() != null) {
                            r.setDirectory(this.fixFilePath(r.getDirectory()));
                            builder.addClasspathDir(r);
                        }
                        if (r.getJar() != null) {
                            r.setJar(this.fixFilePath(r.getJar()));
                            builder.addClasspathJar(r);
                        }
                        if (r.getJarset() != null) {
                            r.setJarset(this.fixFilePath(r.getJarset()));
                            builder.addClasspathJarset(r);
                        }
                        if (r.getDirset() == null) continue;
                        r.setDirset(this.fixFilePath(r.getDirset()));
                        builder.addClasspathDirset(r);
                        continue;
                    }
                    this.buildDefaultClasspath(builder, r);
                }
            }
        }
    }

    private void buildDefaultClasspath(RebelXmlBuilder builder, RebelClasspathResource defaultClasspath) throws MojoExecutionException {
        if (!this.generateDefaultClasspath) {
            return;
        }
        if (this.addResourcesDirToRebelXml) {
            this.buildDefaultClasspathResources(builder);
        }
        RebelClasspathResource r = new RebelClasspathResource();
        r.setDirectory(this.fixFilePath(this.classesDirectory));
        if (defaultClasspath != null) {
            r.setIncludes(defaultClasspath.getIncludes());
            r.setExcludes(defaultClasspath.getExcludes());
        }
        builder.addClasspathDir(r);
    }

    private void buildDefaultClasspathResources(RebelXmlBuilder builder) throws MojoExecutionException {
        boolean overwrite = Boolean.valueOf(this.getPluginSetting(this.getProject(), "org.apache.maven.plugins:maven-resources-plugin", "overwrite", "false"));
        List resources = this.getProject().getResources();
        if (overwrite) {
            Collections.reverse(resources);
        }
        for (Resource resource : resources) {
            File dir = new File(resource.getDirectory());
            if (!dir.isAbsolute()) {
                dir = new File(this.getProject().getBasedir(), resource.getDirectory());
            }
            if (!dir.exists() || !dir.isDirectory()) continue;
            RebelClasspathResource rebelClassPathResource = new RebelClasspathResource();
            if (resource.isFiltering() || resource.getTargetPath() != null) {
                if (!this.handleResourceAsInclude(rebelClassPathResource, resource)) continue;
                rebelClassPathResource.setDirectory(this.fixFilePath(this.classesDirectory));
                if (resource.getTargetPath() != null) {
                    this.setIncludePrefix(rebelClassPathResource.getIncludes(), resource.getTargetPath());
                }
            } else {
                rebelClassPathResource.setDirectory(this.fixFilePath(resource.getDirectory()));
                rebelClassPathResource.setExcludes(resource.getExcludes());
                rebelClassPathResource.setIncludes(resource.getIncludes());
            }
            builder.addClasspathDir(rebelClassPathResource);
        }
    }

    private void setIncludePrefix(List<String> includes, String prefix) {
        if (!prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        for (int i = 0; i < includes.size(); ++i) {
            includes.set(i, prefix + includes.get(i));
        }
    }

    private boolean handleResourceAsInclude(RebelResource rebelResource, Resource resource) {
        ArrayList<String> includedFiles;
        File dir = new File(resource.getDirectory());
        if (!dir.isAbsolute()) {
            dir = new File(this.getProject().getBasedir(), resource.getDirectory());
        }
        if (!dir.exists() || !dir.isDirectory()) {
            return false;
        }
        resource.setDirectory(dir.getAbsolutePath());
        String[] files = this.getFilesToCopy(resource);
        if (files.length > 0) {
            includedFiles = new ArrayList<String>();
            for (String file : files) {
                includedFiles.add(StringUtils.replace((String)file, (char)'\\', (char)'/'));
            }
        } else {
            return false;
        }
        rebelResource.setIncludes(includedFiles);
        return true;
    }

    private String[] getFilesToCopy(Resource resource) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(resource.getDirectory());
        if (resource.getIncludes() != null && !resource.getIncludes().isEmpty()) {
            scanner.setIncludes(resource.getIncludes().toArray(new String[0]));
        } else {
            scanner.setIncludes(DEFAULT_INCLUDES);
        }
        if (resource.getExcludes() != null && !resource.getExcludes().isEmpty()) {
            scanner.setExcludes(resource.getExcludes().toArray(new String[0]));
        }
        scanner.addDefaultExcludes();
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    private void buildWeb(RebelXmlBuilder builder) throws MojoExecutionException {
        RebelWebResource[] resources;
        boolean addDefaultAsFirst = true;
        RebelWebResource defaultWeb = null;
        if (this.web != null && (resources = this.web.getResources()) != null && resources.length > 0) {
            for (RebelWebResource r : resources) {
                if (r.getDirectory() != null || r.getTarget() != null) continue;
                defaultWeb = r;
                addDefaultAsFirst = false;
                break;
            }
        }
        if (addDefaultAsFirst) {
            this.buildDefaultWeb(builder, defaultWeb);
        }
        if (this.web != null && (resources = this.web.getResources()) != null && resources.length > 0) {
            for (RebelWebResource r : resources) {
                if (r.getDirectory() == null && r.getTarget() == null) {
                    this.buildDefaultWeb(builder, r);
                    continue;
                }
                r.setDirectory(this.fixFilePath(r.getDirectory()));
                builder.addWebresource(r);
            }
        }
    }

    private void buildDefaultWeb(RebelXmlBuilder builder, RebelWebResource defaultWeb) throws MojoExecutionException {
        if (!this.generateDefaultWeb) {
            return;
        }
        Xpp3Dom warPluginConf = GenerateRebelMojo.getPluginConfigurationDom(this.getProject(), "org.apache.maven.plugins:maven-war-plugin");
        if (warPluginConf != null) {
            Xpp3Dom wr;
            Xpp3Dom webappDirNode;
            Xpp3Dom warSourceNode = warPluginConf.getChild("warSourceDirectory");
            if (warSourceNode != null && warSourceNode.getValue() != null) {
                this.warSourceDirectory = new File(this.getValue(this.getProject(), warSourceNode));
            }
            if ((webappDirNode = warPluginConf.getChild("webappDirectory")) != null && webappDirNode.getValue() != null) {
                this.webappDirectory = new File(this.getValue(this.getProject(), webappDirNode));
            }
            if ((wr = warPluginConf.getChild("webResources")) != null) {
                List<Resource> resources = this.parseWarResources(wr);
                Collections.reverse(resources);
                for (Resource resource : resources) {
                    File dir = new File(resource.getDirectory());
                    if (!dir.isAbsolute()) {
                        dir = new File(this.getProject().getBasedir(), resource.getDirectory());
                    }
                    if (!dir.exists() || !dir.isDirectory()) continue;
                    if (resource.getTargetPath() == null) {
                        resource.setTargetPath("/");
                    }
                    if (!resource.getTargetPath().endsWith("/")) {
                        resource.setTargetPath(resource.getTargetPath() + "/");
                    }
                    if (resource.getTargetPath().startsWith("WEB-INF/classes/")) {
                        if (!this.addResourcesDirToRebelXml) continue;
                        String target = resource.getTargetPath().substring("WEB-INF/classes/".length());
                        RebelClasspathResource rc = new RebelClasspathResource();
                        if (resource.isFiltering() || StringUtils.isNotEmpty((String)target)) {
                            if (!this.handleResourceAsInclude(rc, resource)) continue;
                            rc.setDirectory(this.fixFilePath(new File(this.webappDirectory, "WEB-INF/classes")));
                            if (StringUtils.isNotEmpty((String)target)) {
                                this.setIncludePrefix(rc.getIncludes(), target);
                            }
                        } else {
                            rc.setDirectory(this.fixFilePath(resource.getDirectory()));
                            rc.setExcludes(resource.getExcludes());
                            rc.setIncludes(resource.getIncludes());
                        }
                        builder.addClasspathDir(rc);
                        continue;
                    }
                    RebelWebResource r = new RebelWebResource();
                    r.setTarget(resource.getTargetPath());
                    if (resource.isFiltering()) {
                        r.setDirectory(this.fixFilePath(new File(this.webappDirectory, resource.getTargetPath())));
                        if (!this.handleResourceAsInclude(r, resource)) {
                            continue;
                        }
                    } else {
                        r.setDirectory(this.fixFilePath(resource.getDirectory()));
                        r.setExcludes(resource.getExcludes());
                        r.setIncludes(resource.getIncludes());
                    }
                    builder.addWebresource(r);
                }
            }
        }
        RebelWebResource r = new RebelWebResource();
        r.setTarget("/");
        r.setDirectory(this.fixFilePath(this.warSourceDirectory));
        if (defaultWeb != null) {
            r.setIncludes(defaultWeb.getIncludes());
            r.setExcludes(defaultWeb.getExcludes());
        }
        builder.addWebresource(r);
    }

    private List<Resource> parseWarResources(Xpp3Dom warResourcesNode) {
        Xpp3Dom[] resourceNodes;
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (Xpp3Dom resourceNode : resourceNodes = warResourcesNode.getChildren("resource")) {
            if (resourceNode == null || resourceNode.getChild("directory") == null) continue;
            resources.add(this.parseResourceNode(resourceNode));
        }
        return resources;
    }

    private Resource parseResourceNode(Xpp3Dom rn) {
        Resource r = new Resource();
        if (rn.getChild("directory") != null) {
            r.setDirectory(this.getValue(this.getProject(), rn.getChild("directory")));
        }
        if (rn.getChild("filtering") != null) {
            r.setFiltering(Boolean.valueOf(this.getValue(this.getProject(), rn.getChild("filtering"))).booleanValue());
        }
        if (rn.getChild("targetPath") != null) {
            r.setTargetPath(rn.getChild("targetPath").getValue());
        }
        if (rn.getChild("excludes") != null) {
            Xpp3Dom[] excludeNodes;
            ArrayList<String> excludes = new ArrayList<String>();
            for (Xpp3Dom excludeNode : excludeNodes = rn.getChild("excludes").getChildren("exclude")) {
                if (excludeNode == null || excludeNode.getValue() == null) continue;
                excludes.add(this.getValue(this.getProject(), excludeNode));
            }
            r.setExcludes(excludes);
        }
        if (rn.getChild("includes") != null) {
            Xpp3Dom[] includeNodes;
            ArrayList<String> includes = new ArrayList<String>();
            for (Xpp3Dom includeNode : includeNodes = rn.getChild("includes").getChildren("include")) {
                if (includeNode == null || includeNode.getValue() == null) continue;
                includes.add(this.getValue(this.getProject(), includeNode));
            }
            r.setIncludes(includes);
        }
        return r;
    }

    private static Xpp3Dom getPluginConfigurationDom(MavenProject project, String pluginId) {
        Plugin plugin = (Plugin)project.getBuild().getPluginsAsMap().get(pluginId);
        if (plugin != null) {
            return (Xpp3Dom)plugin.getConfiguration();
        }
        return null;
    }

    private String getPluginSetting(MavenProject project, String pluginId, String optionName, String defaultValue) {
        Xpp3Dom dom = GenerateRebelMojo.getPluginConfigurationDom(project, pluginId);
        if (dom != null && dom.getChild(optionName) != null) {
            return this.getValue(project, dom.getChild(optionName));
        }
        return defaultValue;
    }

    private String getValue(MavenProject project, Xpp3Dom dom) {
        String value = dom.getValue();
        return this.getValue(project, value);
    }

    private String getValue(MavenProject project, String value) {
        if (value != null && value.contains("$")) {
            return this.getInterpolatorValue(project, value);
        }
        return value;
    }

    private String getInterpolatorValue(MavenProject project, String value) {
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        interpolator.addValueSource((ValueSource)new ObjectBasedValueSource((Object)project));
        try {
            return interpolator.interpolate(value, "project");
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)"Detected exception during 'getInterpolatorValue' : ", (Throwable)e);
            e.printStackTrace();
            return value;
        }
    }

    protected String fixFilePath(String path) throws MojoExecutionException {
        return this.fixFilePath(new File(path));
    }

    protected String fixFilePath(File file) throws MojoExecutionException {
        String relative;
        File baseDir = this.getProject().getFile().getParentFile();
        if (file.isAbsolute() && !GenerateRebelMojo.isRelativeToPath(new File(baseDir, this.getRelativePath()), file)) {
            return StringUtils.replace((String)GenerateRebelMojo.getCanonicalPath(file), (char)'\\', (char)'/');
        }
        if (!file.isAbsolute()) {
            file = new File(baseDir, file.getPath());
        }
        if (!new File(relative = GenerateRebelMojo.getRelativePath(new File(baseDir, this.getRelativePath()), file)).isAbsolute()) {
            return StringUtils.replace((String)this.getRootPath(), (char)'\\', (char)'/') + "/" + relative;
        }
        if (new File(this.getRootPath()).isAbsolute()) {
            String s = GenerateRebelMojo.getRelativePath(new File(this.getRootPath()), file);
            if (!new File(s).isAbsolute()) {
                return StringUtils.replace((String)this.getRootPath(), (char)'\\', (char)'/') + "/" + s;
            }
            return s;
        }
        return StringUtils.replace((String)file.getAbsolutePath(), (char)'\\', (char)'/');
    }

    private static String getRelativePath(File baseDir, File file) throws MojoExecutionException {
        String basedirpath = GenerateRebelMojo.getCanonicalPath(baseDir) + File.separator;
        String absolutePath = GenerateRebelMojo.getCanonicalPath(file);
        String relative = absolutePath.equals(basedirpath) ? "." : (absolutePath.startsWith(basedirpath) ? absolutePath.substring(basedirpath.length()) : absolutePath);
        relative = StringUtils.replace((String)relative, (char)'\\', (char)'/');
        return relative;
    }

    private static boolean isRelativeToPath(File baseDir, File file) throws MojoExecutionException {
        String basedirpath = GenerateRebelMojo.getCanonicalPath(baseDir);
        String absolutePath = GenerateRebelMojo.getCanonicalPath(file);
        return absolutePath.startsWith(basedirpath);
    }

    private static String getCanonicalPath(File file) throws MojoExecutionException {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to get canonical path of " + file.getAbsolutePath(), (Exception)e);
        }
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    String calculatePathToRoot(File root, File folder) throws IOException {
        String result = ".";
        if (root != null && !folder.equals(root)) {
            String normalizedBase = FilenameUtils.normalizeNoEndSeparator((String)folder.getCanonicalPath());
            String normalizedMain = FilenameUtils.normalizeNoEndSeparator((String)root.getCanonicalPath());
            if (normalizedMain.length() > normalizedBase.length()) {
                throw new IOException("Can't find main project folder, module folder = " + normalizedBase + ", calculated main folder = " + normalizedMain);
            }
            String diff = normalizedBase.substring(normalizedMain.length());
            if (diff.length() != 0) {
                StringBuilder buffer = new StringBuilder();
                for (char c : diff.toCharArray()) {
                    if (c != '/' && c != '\\') continue;
                    buffer.append("..").append(File.separatorChar);
                }
                result = buffer.toString();
            }
        }
        this.getLog().debug((CharSequence)("root:" + root + " folder:" + folder + " result:" + result));
        return result;
    }

    String calculateRelativePath(String relativePathToRoot, String rootRelativePath) {
        this.getLog().debug((CharSequence)("relativePathToRoot:" + relativePathToRoot + " rootRelativePath:" + rootRelativePath));
        if (".".equals(relativePathToRoot)) {
            if (".".equals(rootRelativePath)) {
                return ".";
            }
            return rootRelativePath;
        }
        if (".".equals(rootRelativePath)) {
            return relativePathToRoot;
        }
        return relativePathToRoot + rootRelativePath;
    }

    private File findBaseDirOfMainProject() {
        MavenProject current = this.project;
        while (current.hasParent() && current.getParent().getBasedir() != null) {
            current = current.getParent();
        }
        this.getLog().debug((CharSequence)("project:" + this.project + " baseDir:" + current.getBasedir()));
        return current.getBasedir();
    }

    static {
        JAR_PACKAGING.addAll(Arrays.asList("jar", "ejb", "ejb3", "nbm", "hk2-jar", "bundle", "eclipse-plugin", "atlassian-plugin"));
        WAR_PACKAGING.addAll(Arrays.asList("war", "grails-app"));
    }
}

