/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zeroturnaround.bundled.javassist.bytecode.AttributeInfo;
import org.zeroturnaround.bundled.javassist.bytecode.BadBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.ByteArray;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAnalyzer;
import org.zeroturnaround.bundled.javassist.bytecode.CodeIterator;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.ExceptionTable;
import org.zeroturnaround.bundled.javassist.bytecode.Opcode;
import org.zeroturnaround.bundled.javassist.bytecode.StackMapTable;

public class CodeAttribute
extends AttributeInfo
implements Opcode {
    public static final String tag = "Code";
    private int maxStack;
    private int maxLocals;
    private ExceptionTable exceptions;
    private LinkedList attributes;

    public CodeAttribute(ConstPool cp, int stack, int locals, byte[] code, ExceptionTable etable) {
        super(cp, tag);
        this.maxStack = stack;
        this.maxLocals = locals;
        this.info = code;
        this.exceptions = etable;
        this.attributes = new LinkedList();
    }

    private CodeAttribute(ConstPool cp, CodeAttribute src, Map classnames) throws BadBytecode {
        super(cp, tag);
        this.maxStack = src.getMaxStack();
        this.maxLocals = src.getMaxLocals();
        this.exceptions = src.getExceptionTable().copy(cp, classnames);
        this.info = src.copyCode(cp, classnames, this.exceptions, this);
        this.attributes = new LinkedList();
        List src_attr = src.getAttributes();
        int num = src_attr.size();
        for (int i = 0; i < num; ++i) {
            AttributeInfo ai = (AttributeInfo)src_attr.get(i);
            this.attributes.add(ai.copy(cp, classnames));
        }
    }

    CodeAttribute(ConstPool cp, int name_id, DataInputStream in) throws IOException {
        super(cp, name_id, (byte[])null);
        int attr_len = in.readInt();
        this.maxStack = in.readUnsignedShort();
        this.maxLocals = in.readUnsignedShort();
        int code_len = in.readInt();
        this.info = new byte[code_len];
        in.readFully(this.info);
        this.exceptions = new ExceptionTable(cp, in);
        this.attributes = new LinkedList();
        int num = in.readUnsignedShort();
        for (int i = 0; i < num; ++i) {
            this.attributes.add(AttributeInfo.read(cp, in));
        }
    }

    public AttributeInfo copy(ConstPool newCp, Map classnames) throws RuntimeCopyException {
        try {
            return new CodeAttribute(newCp, this, classnames);
        }
        catch (BadBytecode e) {
            throw new RuntimeCopyException("bad bytecode. fatal?");
        }
    }

    public int length() {
        return 18 + this.info.length + this.exceptions.size() * 8 + AttributeInfo.getLength(this.attributes);
    }

    void write(DataOutputStream out) throws IOException {
        out.writeShort(this.name);
        out.writeInt(this.length() - 6);
        out.writeShort(this.maxStack);
        out.writeShort(this.maxLocals);
        out.writeInt(this.info.length);
        out.write(this.info);
        this.exceptions.write(out);
        out.writeShort(this.attributes.size());
        AttributeInfo.writeAll(this.attributes, out);
    }

    public byte[] get() {
        throw new UnsupportedOperationException("CodeAttribute.get()");
    }

    public void set(byte[] newinfo) {
        throw new UnsupportedOperationException("CodeAttribute.set()");
    }

    public String getDeclaringClass() {
        ConstPool cp = this.getConstPool();
        return cp.getClassName();
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public void setMaxStack(int value) {
        this.maxStack = value;
    }

    public int computeMaxStack() throws BadBytecode {
        this.maxStack = new CodeAnalyzer(this).computeMaxStack();
        return this.maxStack;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public void setMaxLocals(int value) {
        this.maxLocals = value;
    }

    public int getCodeLength() {
        return this.info.length;
    }

    public byte[] getCode() {
        return this.info;
    }

    void setCode(byte[] newinfo) {
        super.set(newinfo);
    }

    public CodeIterator iterator() {
        return new CodeIterator(this);
    }

    public ExceptionTable getExceptionTable() {
        return this.exceptions;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public AttributeInfo getAttribute(String name) {
        return AttributeInfo.lookup(this.attributes, name);
    }

    public void setAttribute(StackMapTable smt) {
        AttributeInfo.remove(this.attributes, "StackMapTable");
        if (smt != null) {
            this.attributes.add(smt);
        }
    }

    private byte[] copyCode(ConstPool destCp, Map classnames, ExceptionTable etable, CodeAttribute destCa) throws BadBytecode {
        int len = this.getCodeLength();
        byte[] newCode = new byte[len];
        LdcEntry ldc = CodeAttribute.copyCode(this.info, 0, len, this.getConstPool(), newCode, destCp, classnames);
        return LdcEntry.doit(newCode, ldc, etable, destCa);
    }

    /*
     * WARNING - void declaration
     */
    private static LdcEntry copyCode(byte[] code, int beginPos, int endPos, ConstPool srcCp, byte[] newcode, ConstPool destCp, Map classnameMap) throws BadBytecode {
        LdcEntry ldcEntry = null;
        int n = beginPos;
        while (n < endPos) {
            byte i;
            int ldcEntry2 = CodeIterator.nextOpcode(code, n);
            newcode[n] = i = code[n];
            switch (i & 0xFF) {
                case 19: 
                case 20: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 187: 
                case 189: 
                case 192: 
                case 193: {
                    CodeAttribute.copyConstPoolInfo(n + 1, code, srcCp, newcode, destCp, classnameMap);
                    break;
                }
                case 18: {
                    LdcEntry i2;
                    void index;
                    int c = code[n + 1] & 0xFF;
                    c = srcCp.copy(c, destCp, classnameMap);
                    if (c < 256) {
                        newcode[index + true] = (byte)c;
                        break;
                    }
                    newcode[index] = 0;
                    newcode[index + true] = 0;
                    LdcEntry ldc = new LdcEntry();
                    ldc.where = index;
                    ldc.index = c;
                    ldc.next = i2;
                    i2 = ldc;
                    break;
                }
                case 185: {
                    CodeAttribute.copyConstPoolInfo(n + 1, code, srcCp, newcode, destCp, classnameMap);
                    newcode[n + 3] = code[n + 3];
                    newcode[n + 4] = code[n + 4];
                    break;
                }
                case 197: {
                    CodeAttribute.copyConstPoolInfo(n + 1, code, srcCp, newcode, destCp, classnameMap);
                    newcode[n + 3] = code[n + 3];
                    break;
                }
                default: {
                    while (++n < ldcEntry2) {
                        newcode[n] = code[n];
                    }
                    break block0;
                }
            }
            n = ldcEntry2;
        }
        return ldcEntry;
    }

    private static void copyConstPoolInfo(int i, byte[] code, ConstPool srcCp, byte[] newcode, ConstPool destCp, Map classnameMap) {
        int index = (code[i] & 0xFF) << 8 | code[i + 1] & 0xFF;
        index = srcCp.copy(index, destCp, classnameMap);
        newcode[i] = (byte)(index >> 8);
        newcode[i + 1] = (byte)index;
    }

    public void insertLocalVar(int where, int size) throws BadBytecode {
        CodeIterator ci = this.iterator();
        while (ci.hasNext()) {
            CodeAttribute.shiftIndex(ci, where, size);
        }
        this.setMaxLocals(this.getMaxLocals() + size);
    }

    private static void shiftIndex(CodeIterator ci, int lessThan, int delta) throws BadBytecode {
        int index = ci.next();
        int opcode = ci.byteAt(index);
        if (opcode < 21) {
            return;
        }
        if (opcode < 79) {
            if (opcode < 26) {
                CodeAttribute.shiftIndex8(ci, index, opcode, lessThan, delta);
            } else if (opcode < 46) {
                CodeAttribute.shiftIndex0(ci, index, opcode, lessThan, delta, 26, 21);
            } else {
                if (opcode < 54) {
                    return;
                }
                if (opcode < 59) {
                    CodeAttribute.shiftIndex8(ci, index, opcode, lessThan, delta);
                } else {
                    CodeAttribute.shiftIndex0(ci, index, opcode, lessThan, delta, 59, 54);
                }
            }
        } else if (opcode == 132) {
            int var = ci.byteAt(index + 1);
            if (var < lessThan) {
                return;
            }
            if ((var += delta) < 256) {
                ci.writeByte(var, index + 1);
            } else {
                int plus = ci.byteAt(index + 2);
                ci.insertExGap(3);
                ci.writeByte(196, index);
                ci.writeByte(132, index + 1);
                ci.write16bit(var, index + 2);
                ci.write16bit(plus, index + 4);
            }
        } else if (opcode == 169) {
            CodeAttribute.shiftIndex8(ci, index, opcode, lessThan, delta);
        } else if (opcode == 196) {
            int var = ci.u16bitAt(index + 2);
            if (var < lessThan) {
                return;
            }
            ci.write16bit(var += delta, index + 2);
        }
    }

    private static void shiftIndex8(CodeIterator ci, int index, int opcode, int lessThan, int delta) throws BadBytecode {
        int var = ci.byteAt(index + 1);
        if (var < lessThan) {
            return;
        }
        if ((var += delta) < 256) {
            ci.writeByte(var, index + 1);
        } else {
            ci.insertExGap(2);
            ci.writeByte(196, index);
            ci.writeByte(opcode, index + 1);
            ci.write16bit(var, index + 2);
        }
    }

    private static void shiftIndex0(CodeIterator ci, int index, int opcode, int lessThan, int delta, int opcode_i_0, int opcode_i) throws BadBytecode {
        int var = (opcode - opcode_i_0) % 4;
        if (var < lessThan) {
            return;
        }
        if ((var += delta) < 4) {
            ci.writeByte(opcode + delta, index);
        } else {
            opcode = (opcode - opcode_i_0) / 4 + opcode_i;
            if (var < 256) {
                ci.insertExGap(1);
                ci.writeByte(opcode, index);
                ci.writeByte(var, index + 1);
            } else {
                ci.insertExGap(3);
                ci.writeByte(196, index);
                ci.writeByte(opcode, index + 1);
                ci.write16bit(var, index + 2);
            }
        }
    }

    static class LdcEntry {
        LdcEntry next;
        int where;
        int index;

        LdcEntry() {
        }

        static byte[] doit(byte[] code, LdcEntry ldc, ExceptionTable etable, CodeAttribute ca) throws BadBytecode {
            while (ldc != null) {
                int where = ldc.where;
                code = CodeIterator.insertGap(code, where, 1, false, etable, ca);
                code[where] = 19;
                ByteArray.write16bit(ldc.index, code, where + 1);
                ldc = ldc.next;
            }
            return code;
        }
    }

    public static class RuntimeCopyException
    extends RuntimeException {
        public RuntimeCopyException(String s) {
            super(s);
        }
    }
}

