/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.function.Consumer;
import org.zeromq.ZFrame;
import org.zeromq.ZMQ;
import org.zeromq.ZMQException;

public class ZMsg
implements Iterable<ZFrame>,
Deque<ZFrame> {
    private final ArrayDeque<ZFrame> frames = new ArrayDeque();

    public void destroy() {
        for (ZFrame f : this.frames) {
            f.destroy();
        }
        this.frames.clear();
    }

    public long contentSize() {
        long size = 0L;
        for (ZFrame f : this.frames) {
            size += (long)f.size();
        }
        return size;
    }

    public ZMsg addString(String str) {
        this.frames.add(new ZFrame(str));
        return this;
    }

    public ZMsg duplicate() {
        if (this.frames.isEmpty()) {
            return null;
        }
        ZMsg msg = new ZMsg();
        for (ZFrame f : this.frames) {
            msg.add(f.duplicate());
        }
        return msg;
    }

    public ZMsg wrap(ZFrame frame) {
        if (frame != null) {
            this.push(new ZFrame(""));
            this.push(frame);
        }
        return this;
    }

    public ZFrame unwrap() {
        if (this.size() == 0) {
            return null;
        }
        ZFrame f = this.pop();
        ZFrame empty = this.getFirst();
        if (empty.hasData() && empty.size() == 0) {
            empty = this.pop();
            empty.destroy();
        }
        return f;
    }

    public boolean send(ZMQ.Socket socket) {
        return this.send(socket, true);
    }

    public boolean send(ZMQ.Socket socket, boolean destroy) {
        ZFrame f;
        if (socket == null) {
            throw new IllegalArgumentException("socket is null");
        }
        if (this.frames == null) {
            throw new IllegalArgumentException("destroyed message");
        }
        if (this.frames.size() == 0) {
            return true;
        }
        boolean ret = true;
        Iterator<ZFrame> i = this.frames.iterator();
        while (i.hasNext() && (ret = (f = i.next()).sendAndKeep(socket, i.hasNext() ? 2 : 0))) {
        }
        if (destroy) {
            this.destroy();
        }
        return ret;
    }

    public static ZMsg recvMsg(ZMQ.Socket socket) {
        return ZMsg.recvMsg(socket, 0);
    }

    public static ZMsg recvMsg(ZMQ.Socket socket, boolean wait) {
        return ZMsg.recvMsg(socket, wait ? 0 : 1);
    }

    public static ZMsg recvMsg(ZMQ.Socket socket, int flag) {
        ZFrame f;
        if (socket == null) {
            throw new IllegalArgumentException("socket is null");
        }
        ZMsg msg = new ZMsg();
        do {
            if ((f = ZFrame.recvFrame(socket, flag)) == null) {
                msg.destroy();
                msg = null;
                break;
            }
            msg.add(f);
        } while (f.hasMore());
        return msg;
    }

    public static void recvMsg(ZMQ.Socket socket, int flags, Consumer<ZMsg> handler, Consumer<ZMQException> exceptionHandler) {
        try {
            handler.accept(ZMsg.recvMsg(socket, flags));
        }
        catch (ZMQException e) {
            exceptionHandler.accept(e);
        }
    }

    public static void recvMsg(ZMQ.Socket socket, int flags, Consumer<ZMsg> handler) {
        handler.accept(ZMsg.recvMsg(socket, flags));
    }

    public static boolean save(ZMsg msg, DataOutputStream file) {
        if (msg == null) {
            return false;
        }
        try {
            file.writeInt(msg.size());
            if (msg.size() > 0) {
                for (ZFrame f : msg) {
                    file.writeInt(f.size());
                    file.write(f.getData());
                }
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static ZMsg load(DataInputStream file) {
        if (file == null) {
            return null;
        }
        ZMsg rcvMsg = new ZMsg();
        try {
            int msgSize = file.readInt();
            if (msgSize > 0) {
                int msgNbr = 0;
                while (++msgNbr <= msgSize) {
                    int frameSize = file.readInt();
                    byte[] data = new byte[frameSize];
                    file.read(data);
                    rcvMsg.add(new ZFrame(data));
                }
            }
            return rcvMsg;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static ZMsg newStringMsg(String ... strings) {
        ZMsg msg = new ZMsg();
        for (String data : strings) {
            msg.addString(data);
        }
        return msg;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZMsg zMsg = (ZMsg)o;
        Iterator<ZFrame> e1 = this.frames.iterator();
        Iterator<ZFrame> e2 = zMsg.frames.iterator();
        while (e1.hasNext() && e2.hasNext()) {
            ZFrame o1 = e1.next();
            ZFrame o2 = e2.next();
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    @Override
    public int hashCode() {
        if (this.frames.isEmpty()) {
            return 0;
        }
        int result = 1;
        for (ZFrame frame : this.frames) {
            result = 31 * result + (frame == null ? 0 : frame.hashCode());
        }
        return result;
    }

    public ZMsg dump(Appendable out) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.printf("--------------------------------------\n", new Object[0]);
            for (ZFrame frame : this.frames) {
                pw.printf("[%03d] %s\n", frame.size(), frame.toString());
            }
            out.append(sw.getBuffer());
            sw.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Message dump exception " + super.toString(), e);
        }
        return this;
    }

    public ZMsg dump() {
        this.dump(System.out);
        return this;
    }

    public ZMsg addFirst(String stringValue) {
        this.addFirst(new ZFrame(stringValue));
        return this;
    }

    public ZMsg addFirst(byte[] data) {
        this.addFirst(new ZFrame(data));
        return this;
    }

    public ZMsg addLast(String stringValue) {
        this.addLast(new ZFrame(stringValue));
        return this;
    }

    public ZMsg addLast(byte[] data) {
        this.addLast(new ZFrame(data));
        return this;
    }

    public ZMsg push(String str) {
        this.push(new ZFrame(str));
        return this;
    }

    public ZMsg push(byte[] data) {
        this.push(new ZFrame(data));
        return this;
    }

    @Override
    public boolean add(String stringValue) {
        return this.add(new ZFrame(stringValue));
    }

    @Override
    public boolean add(byte[] data) {
        return this.add(new ZFrame(data));
    }

    public ZMsg append(String stringValue) {
        this.add(stringValue);
        return this;
    }

    public ZMsg append(byte[] data) {
        this.add(data);
        return this;
    }

    @Override
    public Iterator<ZFrame> iterator() {
        return this.frames.iterator();
    }

    @Override
    public boolean addAll(Collection<? extends ZFrame> arg0) {
        return this.frames.addAll(arg0);
    }

    @Override
    public void clear() {
        this.frames.clear();
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return this.frames.containsAll(arg0);
    }

    @Override
    public boolean isEmpty() {
        return this.frames.isEmpty();
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        return this.frames.removeAll(arg0);
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        return this.frames.retainAll(arg0);
    }

    @Override
    public Object[] toArray() {
        return this.frames.toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        return this.frames.toArray(arg0);
    }

    @Override
    public boolean add(ZFrame e) {
        return this.frames.add(e);
    }

    @Override
    public void addFirst(ZFrame e) {
        this.frames.addFirst(e);
    }

    @Override
    public void addLast(ZFrame e) {
        this.frames.addLast(e);
    }

    @Override
    public boolean contains(Object o) {
        return this.frames.contains(o);
    }

    @Override
    public Iterator<ZFrame> descendingIterator() {
        return this.frames.descendingIterator();
    }

    @Override
    public ZFrame element() {
        return this.frames.element();
    }

    @Override
    public ZFrame getFirst() {
        return this.frames.peekFirst();
    }

    @Override
    public ZFrame getLast() {
        return this.frames.peekLast();
    }

    @Override
    public boolean offer(ZFrame e) {
        return this.frames.offer(e);
    }

    @Override
    public boolean offerFirst(ZFrame e) {
        return this.frames.offerFirst(e);
    }

    @Override
    public boolean offerLast(ZFrame e) {
        return this.frames.offerLast(e);
    }

    @Override
    public ZFrame peek() {
        return this.frames.peek();
    }

    @Override
    public ZFrame peekFirst() {
        return this.frames.peekFirst();
    }

    @Override
    public ZFrame peekLast() {
        return this.frames.peekLast();
    }

    @Override
    public ZFrame poll() {
        return this.frames.poll();
    }

    @Override
    public ZFrame pollFirst() {
        return this.frames.pollFirst();
    }

    @Override
    public ZFrame pollLast() {
        return this.frames.pollLast();
    }

    @Override
    public ZFrame pop() {
        return this.frames.poll();
    }

    public String popString() {
        ZFrame frame = this.pop();
        if (frame == null) {
            return null;
        }
        return frame.toString();
    }

    @Override
    public void push(ZFrame e) {
        this.frames.push(e);
    }

    @Override
    public ZFrame remove() {
        return this.frames.remove();
    }

    @Override
    public boolean remove(Object o) {
        return this.frames.remove(o);
    }

    @Override
    public ZFrame removeFirst() {
        return this.frames.pollFirst();
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        return this.frames.removeFirstOccurrence(o);
    }

    @Override
    public ZFrame removeLast() {
        return this.frames.pollLast();
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        return this.frames.removeLastOccurrence(o);
    }

    @Override
    public int size() {
        return this.frames.size();
    }

    public ZMsg append(ZMsg msg) {
        if (msg == null) {
            return this;
        }
        for (ZFrame frame : msg.frames) {
            this.add(frame);
        }
        return this;
    }

    public String toString() {
        StringBuilder out = new StringBuilder("[ ");
        Iterator<ZFrame> frameIterator = this.frames.iterator();
        while (frameIterator.hasNext()) {
            out.append(frameIterator.next());
            if (!frameIterator.hasNext()) continue;
            out.append(", ");
        }
        out.append(" ]");
        return out.toString();
    }
}

