/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.zeromq.SocketType;
import org.zeromq.ZActor;
import org.zeromq.ZAgent;
import org.zeromq.ZContext;
import org.zeromq.ZFrame;
import org.zeromq.ZMQ;
import org.zeromq.ZMsg;
import org.zeromq.ZPoller;
import org.zeromq.ZStar;

public class ZMonitor
implements Closeable {
    private boolean started;
    private static final String START = "START";
    private static final String CLOSE = "CLOSE";
    private static final String VERBOSE = "VERBOSE";
    private static final String ADD_EVENTS = "ADD_EVENTS";
    private static final String REMOVE_EVENTS = "REMOVE_EVENTS";
    private final ZAgent agent;
    private final ZStar.Exit exit;

    public final ZMonitor start() {
        if (this.started) {
            System.out.println("ZMonitor: Unable to start while already started.");
            return this;
        }
        this.agent.send(START);
        this.agent.recv();
        this.started = true;
        return this;
    }

    @Override
    public final void close() throws IOException {
        this.destroy();
    }

    public final void destroy() {
        this.agent.send(CLOSE);
        this.exit.awaitSilent();
        this.agent.close();
    }

    public final ZMonitor verbose(boolean verbose) {
        if (this.started) {
            System.out.println("ZMonitor: Unable to change verbosity while already started.");
            return this;
        }
        this.agent.send(VERBOSE, true);
        this.agent.send(Boolean.toString(verbose));
        this.agent.recv();
        return this;
    }

    public final ZMonitor add(Event ... events) {
        if (this.started) {
            System.out.println("ZMonitor: Unable to add events while already started.");
            return this;
        }
        ZMsg msg = new ZMsg();
        msg.add(ADD_EVENTS);
        for (Event evt : events) {
            msg.add(evt.name());
        }
        this.agent.send(msg);
        this.agent.recv();
        return this;
    }

    public final ZMonitor remove(Event ... events) {
        if (this.started) {
            System.out.println("ZMonitor: Unable to remove events while already started.");
            return this;
        }
        ZMsg msg = new ZMsg();
        msg.add(REMOVE_EVENTS);
        for (Event evt : events) {
            msg.add(evt.name());
        }
        this.agent.send(msg);
        this.agent.recv();
        return this;
    }

    public final ZEvent nextEvent() {
        return this.nextEvent(true);
    }

    public final ZEvent nextEvent(boolean wait) {
        if (!this.started) {
            System.out.println("ZMonitor: Start before getting events.");
            return null;
        }
        ZMsg msg = this.agent.recv(wait);
        if (msg == null) {
            return null;
        }
        return new ZEvent(msg);
    }

    public final ZEvent nextEvent(int timeout) {
        if (!this.started) {
            System.out.println("ZMonitor: Start before getting events.");
            return null;
        }
        ZMsg msg = this.agent.recv(timeout);
        if (msg == null) {
            return null;
        }
        return new ZEvent(msg);
    }

    public ZMonitor(ZContext ctx, ZMQ.Socket socket) {
        Objects.requireNonNull(ctx, "ZMonitor works only with a supplied context");
        Objects.requireNonNull(socket, "Socket has to be supplied");
        MonitorActor actor = new MonitorActor(socket);
        ZActor zactor = new ZActor(ctx, (ZActor.Actor)actor, UUID.randomUUID().toString(), new Object[0]);
        this.agent = zactor.agent();
        this.exit = zactor.exit();
        this.agent.recv().destroy();
    }

    private static class MonitorActor
    extends ZActor.SimpleActor {
        private static final String ERROR = "ERROR";
        private static final String OK = "OK";
        private final ZMQ.Socket monitored;
        private final String address;
        private ZMQ.Socket monitor;
        private int events;
        private boolean verbose;

        public MonitorActor(ZMQ.Socket socket) {
            assert (socket != null);
            this.monitored = socket;
            this.address = String.format("inproc://zmonitor-%s-%s", socket.hashCode(), UUID.randomUUID().toString());
        }

        @Override
        public String premiere(ZMQ.Socket pipe) {
            return "ZMonitor-" + this.monitored.toString();
        }

        @Override
        public List<ZMQ.Socket> createSockets(ZContext ctx, Object ... args) {
            this.monitor = ctx.createSocket(SocketType.PAIR);
            assert (this.monitor != null);
            return Collections.singletonList(this.monitor);
        }

        @Override
        public void start(ZMQ.Socket pipe, List<ZMQ.Socket> sockets, ZPoller poller) {
            pipe.send("STARTED");
        }

        @Override
        public boolean stage(ZMQ.Socket socket, ZMQ.Socket pipe, ZPoller poller, int evts) {
            ZMQ.Event event = ZMQ.Event.recv(socket);
            assert (event != null);
            int code = event.getEvent();
            String address = event.getAddress();
            assert (address != null);
            Event type = Event.find(code);
            assert (type != null);
            ZMsg msg = new ZMsg();
            msg.add(type.name());
            msg.add(Integer.toString(code));
            msg.add(address);
            Object value = event.getValue();
            if (value != null) {
                msg.add(value.toString());
            }
            return msg.send(pipe, true);
        }

        @Override
        public boolean backstage(ZMQ.Socket pipe, ZPoller poller, int evts) {
            String command = pipe.recvStr();
            if (command == null) {
                System.out.printf("ZMonitor: Closing monitor %s : No command%n", this.monitored);
                return false;
            }
            switch (command) {
                case "VERBOSE": {
                    this.verbose = Boolean.parseBoolean(pipe.recvStr());
                    return pipe.send(OK);
                }
                case "ADD_EVENTS": {
                    return this.addEvents(pipe);
                }
                case "REMOVE_EVENTS": {
                    return this.removeEvents(pipe);
                }
                case "START": {
                    return this.start(poller, pipe);
                }
                case "CLOSE": {
                    return this.close(poller, pipe);
                }
            }
            System.out.printf("ZMonitor: Closing monitor %s : Unknown command %s%n", this.monitored, command);
            pipe.send(ERROR);
            return false;
        }

        private boolean addEvents(ZMQ.Socket pipe) {
            ZMsg msg = ZMsg.recvMsg(pipe);
            if (msg == null) {
                return false;
            }
            for (ZFrame frame : msg) {
                String evt = frame.getString(ZMQ.CHARSET);
                Event event = Event.valueOf(evt);
                if (this.verbose) {
                    System.out.printf("ZMonitor: Adding event %s%n", new Object[]{event});
                }
                this.events |= event.events;
            }
            return pipe.send(OK);
        }

        private boolean removeEvents(ZMQ.Socket pipe) {
            ZMsg msg = ZMsg.recvMsg(pipe);
            if (msg == null) {
                return false;
            }
            for (ZFrame frame : msg) {
                String evt = frame.getString(ZMQ.CHARSET);
                Event event = Event.valueOf(evt);
                if (this.verbose) {
                    System.out.printf("ZMonitor: Removing event %s%n", new Object[]{event});
                }
                this.events &= ~event.events;
            }
            return pipe.send(OK);
        }

        private boolean start(ZPoller poller, ZMQ.Socket pipe) {
            boolean rc = true;
            String err = "";
            if (rc) {
                rc = this.monitored.monitor(this.address, this.events);
                err = "Unable to monitor socket " + this.monitored;
            }
            if (rc) {
                err = "Unable to connect monitoring socket " + this.monitor;
                rc = this.monitor.connect(this.address);
            }
            if (rc) {
                err = "Unable to poll monitoring socket " + this.monitor;
                rc = poller.register(this.monitor, 1);
            }
            this.log("tart", rc, err);
            if (rc) {
                return pipe.send(OK);
            }
            pipe.send(ERROR);
            return false;
        }

        private boolean close(ZPoller poller, ZMQ.Socket pipe) {
            boolean rc = poller.unregister(this.monitor);
            String err = "Unable to unregister monitoring socket " + this.monitor;
            if (rc) {
                err = "Unable to stop monitor socket " + this.monitored;
                rc = this.monitored.monitor(null, this.events);
            }
            this.log("top", rc, err);
            if (this.verbose) {
                System.out.printf("ZMonitor: Closing monitor %s%n", this.monitored);
            }
            pipe.send(rc ? OK : ERROR);
            return false;
        }

        private void log(String action, boolean rc, String err) {
            if (this.verbose) {
                if (rc) {
                    System.out.printf("ZMonitor: S%s monitor for events %s on %s%n", action, this.events, this.monitored);
                } else {
                    System.out.printf("ZMonitor: Unable to s%s monitor for events %s (%s) on %s%n", action, this.events, err, this.monitored);
                }
            }
        }
    }

    public static enum Event {
        CONNECTED(1),
        CONNECT_DELAYED(2),
        CONNECT_RETRIED(4),
        LISTENING(8),
        BIND_FAILED(16),
        ACCEPTED(32),
        ACCEPT_FAILED(64),
        CLOSED(128),
        CLOSE_FAILED(256),
        DISCONNECTED(512),
        MONITOR_STOPPED(1024),
        HANDSHAKE_PROTOCOL(32768),
        ALL(65535);

        private final int events;

        private Event(int events) {
            this.events = events;
        }

        private static Event find(int event) {
            for (Event candidate : Event.values()) {
                if ((candidate.events & event) == 0) continue;
                return candidate;
            }
            return ALL;
        }
    }

    public static final class ZEvent {
        public final Event type;
        public final int code;
        public final String address;
        public final String value;

        private ZEvent(ZMsg msg) {
            assert (msg != null);
            assert (msg.size() == 3 || msg.size() == 4) : msg.size();
            this.type = Event.valueOf(msg.popString());
            this.code = Integer.valueOf(msg.popString());
            this.address = msg.popString();
            this.value = msg.isEmpty() ? null : msg.popString();
        }

        public String toString() {
            return "ZEvent [type=" + (Object)((Object)this.type) + ", code=" + this.code + ", address=" + this.address + ", value=" + this.value + "]";
        }
    }
}

