/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import zmq.Command;
import zmq.Ctx;
import zmq.IEngine;
import zmq.IOThread;
import zmq.Own;
import zmq.Pipe;
import zmq.SessionBase;
import zmq.SocketBase;

public abstract class ZObject {
    private final Ctx ctx;
    private final int tid;

    protected ZObject(Ctx ctx, int tid) {
        this.ctx = ctx;
        this.tid = tid;
    }

    protected ZObject(ZObject parent_) {
        this(parent_.ctx, parent_.tid);
    }

    protected int get_tid() {
        return this.tid;
    }

    protected Ctx get_ctx() {
        return this.ctx;
    }

    protected void process_command(Command cmd_) {
        switch (cmd_.type()) {
            case ACTIVATE_READ: {
                this.process_activate_read();
                break;
            }
            case ACTIVATE_WRITE: {
                this.process_activate_write((Long)cmd_.arg);
                break;
            }
            case STOP: {
                this.process_stop();
                break;
            }
            case PLUG: {
                this.process_plug();
                this.process_seqnum();
                break;
            }
            case OWN: {
                this.process_own((Own)cmd_.arg);
                this.process_seqnum();
                break;
            }
            case ATTACH: {
                this.process_attach((IEngine)cmd_.arg);
                this.process_seqnum();
                break;
            }
            case BIND: {
                this.process_bind((Pipe)cmd_.arg);
                this.process_seqnum();
                break;
            }
            case HICCUP: {
                this.process_hiccup(cmd_.arg);
                break;
            }
            case PIPE_TERM: {
                this.process_pipe_term();
                break;
            }
            case PIPE_TERM_ACK: {
                this.process_pipe_term_ack();
                break;
            }
            case TERM_REQ: {
                this.process_term_req((Own)cmd_.arg);
                break;
            }
            case TERM: {
                this.process_term((Integer)cmd_.arg);
                break;
            }
            case TERM_ACK: {
                this.process_term_ack();
                break;
            }
            case REAP: {
                this.process_reap((SocketBase)cmd_.arg);
                break;
            }
            case REAPED: {
                this.process_reaped();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    protected boolean register_endpoint(String addr_, Ctx.Endpoint endpoint_) {
        return this.ctx.register_endpoint(addr_, endpoint_);
    }

    protected void unregister_endpoints(SocketBase socket_) {
        this.ctx.unregister_endpoints(socket_);
    }

    protected Ctx.Endpoint find_endpoint(String addr_) {
        return this.ctx.find_endpoint(addr_);
    }

    protected void destroy_socket(SocketBase socket_) {
        this.ctx.destroy_socket(socket_);
    }

    protected IOThread choose_io_thread(long affinity_) {
        return this.ctx.choose_io_thread(affinity_);
    }

    protected void send_stop() {
        Command cmd = new Command(this, Command.Type.STOP);
        this.ctx.send_command(this.tid, cmd);
    }

    protected void send_plug(Own destination_) {
        this.send_plug(destination_, true);
    }

    protected void send_plug(Own destination_, boolean inc_seqnum_) {
        if (inc_seqnum_) {
            destination_.inc_seqnum();
        }
        Command cmd = new Command(destination_, Command.Type.PLUG);
        this.send_command(cmd);
    }

    protected void send_own(Own destination_, Own object_) {
        destination_.inc_seqnum();
        Command cmd = new Command(destination_, Command.Type.OWN, object_);
        this.send_command(cmd);
    }

    protected void send_attach(SessionBase destination_, IEngine engine_) {
        this.send_attach(destination_, engine_, true);
    }

    protected void send_attach(SessionBase destination_, IEngine engine_, boolean inc_seqnum_) {
        if (inc_seqnum_) {
            destination_.inc_seqnum();
        }
        Command cmd = new Command(destination_, Command.Type.ATTACH, engine_);
        this.send_command(cmd);
    }

    protected void send_bind(Own destination_, Pipe pipe_) {
        this.send_bind(destination_, pipe_, true);
    }

    protected void send_bind(Own destination_, Pipe pipe_, boolean inc_seqnum_) {
        if (inc_seqnum_) {
            destination_.inc_seqnum();
        }
        Command cmd = new Command(destination_, Command.Type.BIND, pipe_);
        this.send_command(cmd);
    }

    protected void send_activate_read(Pipe destination_) {
        Command cmd = new Command(destination_, Command.Type.ACTIVATE_READ);
        this.send_command(cmd);
    }

    protected void send_activate_write(Pipe destination_, long msgs_read_) {
        Command cmd = new Command(destination_, Command.Type.ACTIVATE_WRITE, msgs_read_);
        this.send_command(cmd);
    }

    protected void send_hiccup(Pipe destination_, Object pipe_) {
        Command cmd = new Command(destination_, Command.Type.HICCUP, pipe_);
        this.send_command(cmd);
    }

    protected void send_pipe_term(Pipe destination_) {
        Command cmd = new Command(destination_, Command.Type.PIPE_TERM);
        this.send_command(cmd);
    }

    protected void send_pipe_term_ack(Pipe destination_) {
        Command cmd = new Command(destination_, Command.Type.PIPE_TERM_ACK);
        this.send_command(cmd);
    }

    protected void send_term_req(Own destination_, Own object_) {
        Command cmd = new Command(destination_, Command.Type.TERM_REQ, object_);
        this.send_command(cmd);
    }

    protected void send_term(Own destination_, int linger_) {
        Command cmd = new Command(destination_, Command.Type.TERM, linger_);
        this.send_command(cmd);
    }

    protected void send_term_ack(Own destination_) {
        Command cmd = new Command(destination_, Command.Type.TERM_ACK);
        this.send_command(cmd);
    }

    protected void send_reap(SocketBase socket_) {
        Command cmd = new Command(this.ctx.get_reaper(), Command.Type.REAP, socket_);
        this.send_command(cmd);
    }

    protected void send_reaped() {
        Command cmd = new Command(this.ctx.get_reaper(), Command.Type.REAPED);
        this.send_command(cmd);
    }

    protected void send_done() {
        Command cmd = new Command(null, Command.Type.DONE);
        this.ctx.send_command(0, cmd);
    }

    protected void process_stop() {
        throw new UnsupportedOperationException();
    }

    protected void process_plug() {
        throw new UnsupportedOperationException();
    }

    protected void process_own(Own object) {
        throw new UnsupportedOperationException();
    }

    protected void process_attach(IEngine engine) {
        throw new UnsupportedOperationException();
    }

    protected void process_bind(Pipe pipe) {
        throw new UnsupportedOperationException();
    }

    protected void process_activate_read() {
        throw new UnsupportedOperationException();
    }

    protected void process_activate_write(long msgs_read_) {
        throw new UnsupportedOperationException();
    }

    protected void process_hiccup(Object hiccup_pipe) {
        throw new UnsupportedOperationException();
    }

    protected void process_pipe_term() {
        throw new UnsupportedOperationException();
    }

    protected void process_pipe_term_ack() {
        throw new UnsupportedOperationException();
    }

    protected void process_term_req(Own object) {
        throw new UnsupportedOperationException();
    }

    protected void process_term(int linger) {
        throw new UnsupportedOperationException();
    }

    protected void process_term_ack() {
        throw new UnsupportedOperationException();
    }

    protected void process_reap(SocketBase socket) {
        throw new UnsupportedOperationException();
    }

    protected void process_reaped() {
        throw new UnsupportedOperationException();
    }

    protected void process_seqnum() {
        throw new UnsupportedOperationException();
    }

    private void send_command(Command cmd_) {
        this.ctx.send_command(cmd_.destination().get_tid(), cmd_);
    }
}

