/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.clientapi.gen;

import java.util.HashMap;
import org.zaproxy.clientapi.core.ApiResponse;
import org.zaproxy.clientapi.core.ClientApi;
import org.zaproxy.clientapi.core.ClientApiException;
import org.zaproxy.clientapi.gen.deprecated.HttpSessionsDeprecated;

public class HttpSessions
extends HttpSessionsDeprecated {
    private final ClientApi api;

    public HttpSessions(ClientApi api) {
        super(api);
        this.api = api;
    }

    public ApiResponse sites() throws ClientApiException {
        return this.api.callApi("httpSessions", "view", "sites", null);
    }

    public ApiResponse sessions(String site, String session) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("site", site);
        if (session != null) {
            map.put("session", session);
        }
        return this.api.callApi("httpSessions", "view", "sessions", map);
    }

    public ApiResponse activeSession(String site) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("site", site);
        return this.api.callApi("httpSessions", "view", "activeSession", map);
    }

    public ApiResponse sessionTokens(String site) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("site", site);
        return this.api.callApi("httpSessions", "view", "sessionTokens", map);
    }

    public ApiResponse defaultSessionTokens() throws ClientApiException {
        return this.api.callApi("httpSessions", "view", "defaultSessionTokens", null);
    }

    public ApiResponse createEmptySession(String site, String session) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("site", site);
        if (session != null) {
            map.put("session", session);
        }
        return this.api.callApi("httpSessions", "action", "createEmptySession", map);
    }

    public ApiResponse removeSession(String site, String session) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("site", site);
        map.put("session", session);
        return this.api.callApi("httpSessions", "action", "removeSession", map);
    }

    public ApiResponse setActiveSession(String site, String session) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("site", site);
        map.put("session", session);
        return this.api.callApi("httpSessions", "action", "setActiveSession", map);
    }

    public ApiResponse unsetActiveSession(String site) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("site", site);
        return this.api.callApi("httpSessions", "action", "unsetActiveSession", map);
    }

    public ApiResponse addSessionToken(String site, String sessiontoken) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("site", site);
        map.put("sessionToken", sessiontoken);
        return this.api.callApi("httpSessions", "action", "addSessionToken", map);
    }

    public ApiResponse removeSessionToken(String site, String sessiontoken) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("site", site);
        map.put("sessionToken", sessiontoken);
        return this.api.callApi("httpSessions", "action", "removeSessionToken", map);
    }

    public ApiResponse setSessionTokenValue(String site, String session, String sessiontoken, String tokenvalue) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("site", site);
        map.put("session", session);
        map.put("sessionToken", sessiontoken);
        map.put("tokenValue", tokenvalue);
        return this.api.callApi("httpSessions", "action", "setSessionTokenValue", map);
    }

    public ApiResponse renameSession(String site, String oldsessionname, String newsessionname) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("site", site);
        map.put("oldSessionName", oldsessionname);
        map.put("newSessionName", newsessionname);
        return this.api.callApi("httpSessions", "action", "renameSession", map);
    }

    public ApiResponse addDefaultSessionToken(String sessiontoken, String tokenenabled) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sessionToken", sessiontoken);
        if (tokenenabled != null) {
            map.put("tokenEnabled", tokenenabled);
        }
        return this.api.callApi("httpSessions", "action", "addDefaultSessionToken", map);
    }

    public ApiResponse setDefaultSessionTokenEnabled(String sessiontoken, String tokenenabled) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sessionToken", sessiontoken);
        map.put("tokenEnabled", tokenenabled);
        return this.api.callApi("httpSessions", "action", "setDefaultSessionTokenEnabled", map);
    }

    public ApiResponse removeDefaultSessionToken(String sessiontoken) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sessionToken", sessiontoken);
        return this.api.callApi("httpSessions", "action", "removeDefaultSessionToken", map);
    }
}

