/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.clientapi.core;

import org.zaproxy.clientapi.core.ApiResponseSet;

public class Alert {
    private String id;
    private String name;
    private Risk risk;
    @Deprecated
    private Reliability reliability;
    private Confidence confidence;
    private String url;
    private String other;
    private String param;
    private String attack;
    private String evidence;
    private String description;
    private String reference;
    private String solution;
    private int cweId;
    private int wascId;
    private String messageId;
    private String pluginId;

    public Alert(ApiResponseSet apiResponseSet) {
        this.id = apiResponseSet.getStringValue("id");
        this.pluginId = apiResponseSet.getStringValue("pluginId");
        String name = apiResponseSet.getStringValue("name");
        if (name == null) {
            name = apiResponseSet.getStringValue("alert");
        }
        this.name = name;
        this.description = apiResponseSet.getStringValue("description");
        this.risk = Alert.stringToRisk(apiResponseSet.getStringValue("risk"));
        this.confidence = Alert.stringToConfidence(apiResponseSet.getStringValue("confidence"));
        this.url = apiResponseSet.getStringValue("url");
        this.other = apiResponseSet.getStringValue("other");
        this.param = apiResponseSet.getStringValue("param");
        this.attack = apiResponseSet.getStringValue("attack");
        this.evidence = apiResponseSet.getStringValue("evidence");
        this.reference = apiResponseSet.getStringValue("reference");
        this.cweId = Alert.stringToInt(apiResponseSet.getStringValue("cweid"), 0);
        this.wascId = Alert.stringToInt(apiResponseSet.getStringValue("wascid"), 0);
        this.solution = apiResponseSet.getStringValue("solution");
        this.messageId = apiResponseSet.getStringValue("messageId");
    }

    public Alert(String name, String url, String riskStr, String confidenceStr, String param, String other) {
        this.name = name;
        this.url = url;
        this.other = other;
        this.param = param;
        this.risk = Alert.stringToRisk(riskStr);
        this.confidence = Alert.stringToConfidence(confidenceStr);
    }

    public Alert(String name, String url, Risk risk, Confidence confidence, String param, String other, String attack, String description, String reference, String solution, String evidence, int cweId, int wascId) {
        this.name = name;
        this.risk = risk;
        this.confidence = confidence;
        this.url = url;
        this.other = other;
        this.param = param;
        this.attack = attack;
        this.description = description;
        this.reference = reference;
        this.solution = solution;
        this.evidence = evidence;
        this.cweId = cweId;
        this.wascId = wascId;
    }

    public Alert(String name, String url, Risk risk, Confidence confidence, String param, String other) {
        this.name = name;
        this.risk = risk;
        this.confidence = confidence;
        this.url = url;
        this.other = other;
        this.param = param;
    }

    public Alert(String name, String url, Risk risk, Confidence confidence) {
        this.name = name;
        this.risk = risk;
        this.confidence = confidence;
        this.url = url;
    }

    public Alert(String name, String url) {
        this.name = name;
        this.url = url;
    }

    private static int stringToInt(String string, int defaultValue) {
        if (string == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    private static Risk stringToRisk(String string) {
        if (string == null) {
            return null;
        }
        return Risk.valueOf(string);
    }

    private static Confidence stringToConfidence(String string) {
        if (string == null) {
            return null;
        }
        if ("False Positive".equalsIgnoreCase(string)) {
            return Confidence.FalsePositive;
        }
        return Confidence.valueOf(string);
    }

    public String getId() {
        return this.id;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Deprecated
    public String getAlert() {
        return this.name;
    }

    @Deprecated
    public void setAlert(String name) {
        this.name = name;
    }

    public Risk getRisk() {
        return this.risk;
    }

    public void setRisk(Risk risk) {
        this.risk = risk;
    }

    public void setRisk(String risk) {
        this.risk = Risk.valueOf(risk);
    }

    @Deprecated
    public Reliability getReliability() {
        return this.reliability;
    }

    @Deprecated
    public void setReliability(Reliability reliability) {
        this.reliability = reliability;
    }

    @Deprecated
    public void setReliability(String reliability) {
        this.reliability = Reliability.valueOf(reliability);
    }

    public Confidence getConfidence() {
        return this.confidence;
    }

    public void setConfidence(Confidence confidence) {
        this.confidence = confidence;
    }

    public void setConfidence(String confidence) {
        this.confidence = Confidence.valueOf(confidence);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getOther() {
        return this.other;
    }

    public void setOther(String other) {
        this.other = other;
    }

    public String getParam() {
        return this.param;
    }

    public void setParam(String param) {
        this.param = param;
    }

    public String getAttack() {
        return this.attack;
    }

    public String getDescription() {
        return this.description;
    }

    public String getReference() {
        return this.reference;
    }

    public String getSolution() {
        return this.solution;
    }

    public String getEvidence() {
        return this.evidence;
    }

    public int getCweId() {
        return this.cweId;
    }

    public int getWascId() {
        return this.wascId;
    }

    public boolean matches(Alert alertFilter) {
        boolean matches = true;
        if (alertFilter.getName() != null && !alertFilter.getName().equals(this.name)) {
            matches = false;
        }
        if (alertFilter.getRisk() != null && !alertFilter.getRisk().equals((Object)this.risk)) {
            matches = false;
        }
        if (alertFilter.getConfidence() != null && !alertFilter.getConfidence().equals((Object)this.confidence)) {
            matches = false;
        }
        return matches;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.attack == null ? 0 : this.attack.hashCode());
        result = 31 * result + this.cweId;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.evidence == null ? 0 : this.evidence.hashCode());
        result = 31 * result + (this.other == null ? 0 : this.other.hashCode());
        result = 31 * result + (this.param == null ? 0 : this.param.hashCode());
        result = 31 * result + (this.reference == null ? 0 : this.reference.hashCode());
        result = 31 * result + (this.confidence == null ? 0 : this.confidence.hashCode());
        result = 31 * result + (this.risk == null ? 0 : this.risk.hashCode());
        result = 31 * result + (this.solution == null ? 0 : this.solution.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        result = 31 * result + this.wascId;
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Alert)) {
            return false;
        }
        Alert otherAlert = (Alert)object;
        if (this.name == null ? otherAlert.name != null : !this.name.equals(otherAlert.name)) {
            return false;
        }
        if (this.attack == null ? otherAlert.attack != null : !this.attack.equals(otherAlert.attack)) {
            return false;
        }
        if (this.cweId != otherAlert.cweId) {
            return false;
        }
        if (this.description == null ? otherAlert.description != null : !this.description.equals(otherAlert.description)) {
            return false;
        }
        if (this.evidence == null ? otherAlert.evidence != null : !this.evidence.equals(otherAlert.evidence)) {
            return false;
        }
        if (this.other == null ? otherAlert.other != null : !this.other.equals(otherAlert.other)) {
            return false;
        }
        if (this.param == null ? otherAlert.param != null : !this.param.equals(otherAlert.param)) {
            return false;
        }
        if (this.reference == null ? otherAlert.reference != null : !this.reference.equals(otherAlert.reference)) {
            return false;
        }
        if (this.confidence != otherAlert.confidence) {
            return false;
        }
        if (this.risk != otherAlert.risk) {
            return false;
        }
        if (this.solution == null ? otherAlert.solution != null : !this.solution.equals(otherAlert.solution)) {
            return false;
        }
        if (this.url == null ? otherAlert.url != null : !this.url.equals(otherAlert.url)) {
            return false;
        }
        return this.wascId == otherAlert.wascId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\tAlert: ").append(this.getAlert()).append(", ");
        sb.append("Risk: ");
        if (this.getRisk() != null) {
            sb.append(this.getRisk().name());
        } else {
            sb.append("null");
        }
        sb.append(", ");
        sb.append("Confidence: ");
        if (this.getConfidence() != null) {
            sb.append(this.getConfidence().name());
        } else {
            sb.append("null");
        }
        sb.append(", ");
        sb.append("Url: ").append(this.getUrl()).append(", ");
        sb.append("Param: ").append(this.getParam()).append(", ");
        sb.append("Other: ").append(this.getOther());
        return sb.toString();
    }

    public static enum Confidence {
        FalsePositive,
        Low,
        Medium,
        High,
        Confirmed;

    }

    @Deprecated
    public static enum Reliability {
        Suspicious,
        Warning;

    }

    public static enum Risk {
        Informational,
        Low,
        Medium,
        High;

    }
}

