/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.addon.commonlib;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.parosproxy.paros.model.Model;

public final class CookieUtils {
    private static final int NOT_FOUND = -1;
    private static final Logger LOGGER = Logger.getLogger(CookieUtils.class);

    private CookieUtils() {
    }

    public static boolean hasAttribute(String headerValue, String attributeName) {
        CookieUtils.validateParameterNotNull(headerValue, "headerValue");
        CookieUtils.validateParameterNotNull(attributeName, "attributeName");
        if (headerValue.isEmpty() || attributeName.isEmpty()) {
            return false;
        }
        String[] cookieElements = headerValue.split(";");
        if (cookieElements.length == 1 || !CookieUtils.isCookieNameValuePairValid(cookieElements[0])) {
            return false;
        }
        for (int i = 1; i < cookieElements.length; ++i) {
            String[] attribute = cookieElements[i].split("=", 2);
            if (!attributeName.equalsIgnoreCase(attribute[0].trim())) continue;
            return true;
        }
        return false;
    }

    public static String getAttributeValue(String headerValue, String attributeName) {
        CookieUtils.validateParameterNotNull(headerValue, "headerValue");
        CookieUtils.validateParameterNotNull(attributeName, "attributeName");
        if (headerValue.isEmpty() || attributeName.isEmpty()) {
            return null;
        }
        String[] cookieElements = headerValue.split(";");
        if (cookieElements.length == 1 || !CookieUtils.isCookieNameValuePairValid(cookieElements[0])) {
            return null;
        }
        for (int i = 1; i < cookieElements.length; ++i) {
            String[] attribute = cookieElements[i].split("=", 2);
            if (attribute.length <= 1 || !attributeName.equalsIgnoreCase(attribute[0].trim())) continue;
            return attribute[1].trim();
        }
        return null;
    }

    public static String getCookieName(String cookieHeaderValue) {
        CookieUtils.validateParameterNotNull(cookieHeaderValue, "cookieHeaderValue");
        if (cookieHeaderValue.isEmpty()) {
            return null;
        }
        int nameValuePairIdx = cookieHeaderValue.indexOf(61);
        if (nameValuePairIdx == -1) {
            return null;
        }
        return cookieHeaderValue.substring(0, nameValuePairIdx).trim();
    }

    public static String getSetCookiePlusName(String header, String cookieHeaderValue) {
        CookieUtils.validateParameterNotNull(header, "header");
        CookieUtils.validateParameterNotNull(cookieHeaderValue, "cookieHeaderValue");
        if (header.isEmpty() || cookieHeaderValue.isEmpty()) {
            return null;
        }
        String name = CookieUtils.getCookieName(cookieHeaderValue);
        Pattern pattern = Pattern.compile("Set-Cookie.*" + Pattern.quote(cookieHeaderValue), 2);
        Matcher matcher = pattern.matcher(header);
        if (matcher.find()) {
            String match = matcher.group();
            return match.substring(0, match.indexOf(name) + name.length());
        }
        return null;
    }

    private static boolean isCookieNameValuePairValid(String nameValuePair) {
        int nameValuePairIdx = nameValuePair.indexOf(61);
        if (nameValuePairIdx == -1) {
            return false;
        }
        String cookieName = nameValuePair.substring(0, nameValuePairIdx).trim();
        return !cookieName.isEmpty();
    }

    private static void validateParameterNotNull(Object parameter, String name) {
        if (parameter == null) {
            throw new IllegalArgumentException("The parameter " + name + " must not be null.");
        }
    }

    public static Set<String> getCookieIgnoreList(Model model) {
        HashSet<String> ignoreList = new HashSet<String>();
        String ignoreConf = model.getOptionsParam().getConfig().getString("rules.cookie.ignorelist");
        if (ignoreConf != null && ignoreConf.length() > 0) {
            for (String str : ignoreConf.split(",")) {
                String strTrim = str.trim();
                if (strTrim.length() <= 0) continue;
                ignoreList.add(strTrim);
            }
        }
        return ignoreList;
    }

    public static boolean isExpired(String headerValue) {
        LocalDateTime dateTime;
        block5: {
            String expiry = CookieUtils.getAttributeValue(headerValue, "expires");
            if (expiry == null) {
                return false;
            }
            DateTimeFormatter df = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.ROOT);
            dateTime = null;
            try {
                dateTime = LocalDateTime.parse(expiry, df);
            }
            catch (DateTimeParseException dtpe) {
                DateTimeFormatter dfHyphen = DateTimeFormatter.ofPattern("EEE, dd-MMM-yyyy HH:mm:ss zzz", Locale.ROOT);
                try {
                    dateTime = LocalDateTime.parse(expiry, dfHyphen);
                }
                catch (DateTimeParseException dtpEx) {
                    if (!LOGGER.isDebugEnabled()) break block5;
                    LOGGER.debug((Object)("Couldn't parse LocalDateTime from: " + headerValue), (Throwable)dtpEx);
                }
            }
        }
        return dateTime != null && dateTime.isBefore(LocalDateTime.now());
    }
}

