/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.addon.commonlib;

import java.io.IOException;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.AbstractAppPlugin;
import org.parosproxy.paros.core.scanner.Kb;
import org.parosproxy.paros.network.HttpMessage;

public abstract class AbstractAppFilePlugin
extends AbstractAppPlugin {
    private static final Logger LOG = Logger.getLogger(AbstractAppFilePlugin.class);
    private final String filename;
    private final String messagePrefix;

    protected AbstractAppFilePlugin(String filename, String messagePrefix) {
        this.filename = filename;
        this.messagePrefix = messagePrefix;
    }

    public String getName() {
        return Constant.messages.getString(this.messagePrefix + "name");
    }

    public String getDescription() {
        return Constant.messages.getString(this.messagePrefix + "desc");
    }

    public String getSolution() {
        return Constant.messages.getString(this.messagePrefix + "soln");
    }

    public String getReference() {
        return Constant.messages.getString(this.messagePrefix + "refs");
    }

    public int getCategory() {
        return 0;
    }

    public int getRisk() {
        return 2;
    }

    public int getCweId() {
        return 215;
    }

    public int getWascId() {
        return 13;
    }

    private String getOtherInfo() {
        return Constant.messages.getString(this.messagePrefix + "otherinfo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan() {
        if (this.isStop()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Scanner " + this.getName() + " Stopping."));
            }
            return;
        }
        HttpMessage newRequest = this.getNewMsg();
        newRequest.getRequestHeader().setMethod("GET");
        URI baseUri = this.getBaseMsg().getRequestHeader().getURI();
        URI newUri = null;
        try {
            String baseUriPath = baseUri.getPath() == null ? "" : baseUri.getPath();
            newUri = new URI(baseUri.getScheme(), null, baseUri.getHost(), baseUri.getPort(), this.createTestablePath(baseUriPath));
        }
        catch (URIException uEx) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("An error occurred creating a URI for the: " + this.getName() + " scanner. " + uEx.getMessage()), (Throwable)uEx);
            }
            return;
        }
        try {
            newRequest.getRequestHeader().setURI(newUri);
        }
        catch (URIException uEx) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("An error occurred setting the URI for a new request used by: " + this.getName() + " scanner. " + uEx.getMessage()), (Throwable)uEx);
            }
            return;
        }
        Kb uEx = this.getKb();
        synchronized (uEx) {
            if (this.getKb().getBoolean(newUri, this.messagePrefix)) {
                return;
            }
            this.getKb().add(newUri, this.messagePrefix, (Object)Boolean.TRUE);
        }
        try {
            this.sendAndReceive(newRequest, false);
        }
        catch (IOException e) {
            LOG.warn((Object)("An error occurred while checking [" + newRequest.getRequestHeader().getMethod() + "] [" + newRequest.getRequestHeader().getURI() + "] for " + this.getName() + " Caught " + e.getClass().getName() + " " + e.getMessage()));
            return;
        }
        if (this.isFalsePositive(newRequest)) {
            return;
        }
        int statusCode = newRequest.getResponseHeader().getStatusCode();
        if (statusCode == 200) {
            this.raiseAlert(newRequest, this.getRisk(), "");
        } else if (statusCode == 401 || statusCode == 403) {
            this.raiseAlert(newRequest, 0, this.getOtherInfo());
        }
    }

    public boolean isFalsePositive(HttpMessage msg) {
        return false;
    }

    private String createTestablePath(String baseUriPath) {
        String newPath = "";
        newPath = baseUriPath.contains("/") ? (baseUriPath.endsWith("/") ? baseUriPath + this.filename : baseUriPath.substring(0, baseUriPath.lastIndexOf(47)) + "/" + this.filename) : baseUriPath + "/" + this.filename;
        return newPath;
    }

    private void raiseAlert(HttpMessage msg, int risk, String otherInfo) {
        this.newAlert().setRisk(risk).setConfidence(3).setOtherInfo(otherInfo).setEvidence(msg.getResponseHeader().getPrimeHeader()).setMessage(msg).raise();
    }
}

