/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zally;

import com.typesafe.config.Config;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.core.util.OpenApiUtilKt;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zally.ZallyRuleSet;

@Rule(ruleSet=ZallyRuleSet.class, id="S007", severity=Severity.SHOULD, title="Define bounds for lengths of string properties")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J;\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00010\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u00062\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00010\u0017H\u0002R\"\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lorg/zalando/zally/ruleset/zally/StringPropertyLengthBoundsRule;", "", "config", "Lcom/typesafe/config/Config;", "(Lcom/typesafe/config/Config;)V", "formatWhitelist", "", "", "kotlin.jvm.PlatformType", "getFormatWhitelist$zally_ruleset_zally", "()Ljava/util/List;", "patternImpliesLimits", "", "getPatternImpliesLimits$zally_ruleset_zally", "()Z", "checkStringLengthBound", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "bound", "value", "", "schema", "Lio/swagger/v3/oas/models/media/Schema;", "(Lorg/zalando/zally/rule/api/Context;Ljava/lang/String;Ljava/lang/Integer;Lio/swagger/v3/oas/models/media/Schema;)Ljava/util/List;", "checkStringLengthBounds", "checkStringLengthBoundsReversed", "zally-ruleset-zally"})
public final class StringPropertyLengthBoundsRule {
    @NotNull
    private final List<String> formatWhitelist;
    private final boolean patternImpliesLimits;

    public StringPropertyLengthBoundsRule(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        List list = config.getStringList("StringPropertyLengthBoundsRule.formatWhitelist");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"config\n        .getStrin\u2026ndsRule.formatWhitelist\")");
        this.formatWhitelist = CollectionsKt.toList((Iterable)list);
        this.patternImpliesLimits = config.getBoolean("StringPropertyLengthBoundsRule.patternImpliesLimits");
    }

    @NotNull
    public final List<String> getFormatWhitelist$zally_ruleset_zally() {
        return this.formatWhitelist;
    }

    public final boolean getPatternImpliesLimits$zally_ruleset_zally() {
        return this.patternImpliesLimits;
    }

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.SHOULD)
    @NotNull
    public final List<Violation> checkStringLengthBounds(@NotNull Context context) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Map $this$filterValues$iv = OpenApiUtilKt.getAllProperties((OpenAPI)context.getApi());
        boolean $i$f$filterValues = false;
        Map result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            Schema schema = (Schema)entry$iv.getValue();
            boolean bl = false;
            boolean bl2 = !Intrinsics.areEqual((Object)schema.getType(), (Object)"string") ? false : (this.formatWhitelist.contains(schema.getFormat()) ? false : (schema.getPattern() != null && this.patternImpliesLimits ? false : schema.getEnum() == null));
            if (!bl2) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map $this$flatMap$iv = result$iv;
        boolean $i$f$flatMap = false;
        result$iv = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            Schema schema = (Schema)entry.getValue();
            Iterable list$iv$iv = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.checkStringLengthBoundsReversed(context, (Schema<Object>)schema), (Iterable)this.checkStringLengthBound(context, "minLength", schema.getMinLength(), (Schema<Object>)schema)), (Iterable)this.checkStringLengthBound(context, "maxLength", schema.getMaxLength(), (Schema<Object>)schema));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final List<Violation> checkStringLengthBoundsReversed(Context context, Schema<Object> schema) {
        List list;
        if (schema.getMinLength() != null && schema.getMaxLength() != null) {
            Integer n = schema.getMinLength();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"schema.minLength");
            int n2 = ((Number)n).intValue();
            Integer n3 = schema.getMaxLength();
            Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"schema.maxLength");
            if (n2 > ((Number)n3).intValue()) {
                list = context.violations("minLength > maxLength is invalid", schema);
                return list;
            }
        }
        list = CollectionsKt.emptyList();
        return list;
    }

    private final List<Violation> checkStringLengthBound(Context context, String bound, Integer value, Schema<Object> schema) {
        return value == null ? context.violations("No " + bound + " defined", schema) : (value < 0 ? context.violations("Negative " + bound + " is invalid", schema) : CollectionsKt.emptyList());
    }
}

