/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zally;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.core.util.OpenApiUtilKt;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zally.ZallyRuleSet;

@Rule(ruleSet=ZallyRuleSet.class, id="Z001", severity=Severity.MUST, title="Path parameters validation")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\u000b"}, d2={"Lorg/zalando/zally/ruleset/zally/PathParameterRule;", "", "()V", "checkRequiredPathAttribute", "", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "checkSchemaOrContentProperty", "validateParameterContentMapStructure", "Companion", "zally-ruleset-zally"})
public final class PathParameterRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String REQUIRED_ATTRIBUTE_ERROR_MESSAGE = "Parameter with location \"path\" must have an attribute \"required=true\" set";

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> checkRequiredPathAttribute(@NotNull Context context) {
        void $this$mapTo$iv$iv;
        Parameter parameter;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Iterable $this$filter$iv = OpenApiUtilKt.getAllParameters((OpenAPI)context.getApi());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            parameter = (Parameter)element$iv$iv;
            boolean bl = false;
            if (!(OpenApiUtilKt.isInPath((Parameter)parameter) && parameter.getRequired() == false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            parameter = (Parameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(context.violation(REQUIRED_ATTRIBUTE_ERROR_MESSAGE, (Object)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> checkSchemaOrContentProperty(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.isOpenAPI3()) {
            void $this$mapTo$iv$iv;
            Parameter it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = OpenApiUtilKt.getAllParameters((OpenAPI)context.getApi());
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Parameter)element$iv$iv;
                boolean bl = false;
                if (!(it.getSchema() == null && it.getContent() == null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void parameter;
                it = (Parameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = parameter.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parameter.name");
                collection.add(context.violation(Companion.requiredSchemaOrContentErrorMessage(string), (Object)parameter));
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> validateParameterContentMapStructure(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.isOpenAPI3()) {
            void $this$mapTo$iv$iv;
            Parameter it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = OpenApiUtilKt.getAllParameters((OpenAPI)context.getApi());
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Parameter)element$iv$iv;
                boolean bl = false;
                boolean bl2 = it.getContent() != null ? it.getContent().isEmpty() || it.getContent().size() > 1 : false;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void parameter;
                it = (Parameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = parameter.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parameter.name");
                collection.add(context.violation(Companion.contentMapStructureErrorMessage(string), (Object)parameter));
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.emptyList();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/zalando/zally/ruleset/zally/PathParameterRule$Companion;", "", "()V", "REQUIRED_ATTRIBUTE_ERROR_MESSAGE", "", "contentMapStructureErrorMessage", "parameterName", "requiredSchemaOrContentErrorMessage", "zally-ruleset-zally"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String requiredSchemaOrContentErrorMessage(@NotNull String parameterName) {
            Intrinsics.checkNotNullParameter((Object)parameterName, (String)"parameterName");
            return "Parameter " + parameterName + " should have either \"schema\" or \"content\" defined";
        }

        @NotNull
        public final String contentMapStructureErrorMessage(@NotNull String parameterName) {
            Intrinsics.checkNotNullParameter((Object)parameterName, (String)"parameterName");
            return "Parameter " + parameterName + ": \"content\" property should have exactly one entry";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

