/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zally;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.core.util.OpenApiUtilKt;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zally.ZallyRuleSet;

@Rule(ruleSet=ZallyRuleSet.class, id="S006", severity=Severity.SHOULD, title="Define bounds for numeric properties")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J,\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0001H\u0002\u00a8\u0006\u000e"}, d2={"Lorg/zalando/zally/ruleset/zally/NumericPropertyBoundsRule;", "", "()V", "checkNumericBounds", "", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "violationsIfNull", "value", "Ljava/math/BigDecimal;", "description", "", "location", "zally-ruleset-zally"})
public final class NumericPropertyBoundsRule {
    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.SHOULD)
    @NotNull
    public final List<Violation> checkNumericBounds(@NotNull Context context) {
        void $this$flatMapTo$iv$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Map $this$filterValues$iv = OpenApiUtilKt.getAllProperties((OpenAPI)context.getApi());
        boolean $i$f$filterValues = false;
        Map result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            Schema schema = (Schema)entry$iv.getValue();
            boolean bl = false;
            object = new String[]{"integer", "number"};
            if (!ArraysKt.contains((Object[])object, (Object)schema.getType())) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map $this$flatMap$iv = result$iv;
        boolean $i$f$flatMap = false;
        result$iv = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Map.Entry element$iv$iv : $this$flatMapTo$iv$iv.entrySet()) {
            object = element$iv$iv;
            boolean bl = false;
            Schema schema = (Schema)object.getValue();
            Iterable list$iv$iv = CollectionsKt.plus((Collection)this.violationsIfNull(context, schema.getMinimum(), "No minimum defined", schema), (Iterable)this.violationsIfNull(context, schema.getMaximum(), "No maximum defined", schema));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<Violation> violationsIfNull(Context $this$violationsIfNull, BigDecimal value, String description, Object location) {
        return value != null ? CollectionsKt.emptyList() : $this$violationsIfNull.violations(description, location);
    }
}

