/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zally;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.core.JsonPointerExtensionsKt;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zally.NoUnusedDefinitionsRule;
import org.zalando.zally.ruleset.zally.ZallyRuleSet;

@Rule(ruleSet=ZallyRuleSet.class, id="S005", severity=Severity.SHOULD, title="Do not leave unused definitions")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u0007H\u0002J4\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012H\u0002J2\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\u0006\u0010\f\u001a\u00020\u00072\u001a\u0010\u0013\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00040\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/zalando/zally/ruleset/zally/NoUnusedDefinitionsRule;", "", "()V", "checkOpenAPI", "", "Lorg/zalando/zally/rule/api/Violation;", "root", "Lcom/fasterxml/jackson/databind/JsonNode;", "checkSwagger", "reference", "Lkotlin/sequences/Sequence;", "Lcom/fasterxml/jackson/core/JsonPointer;", "node", "unused", "pointer", "", "description", "used", "", "discriminators", "Lkotlin/Function1;", "zally-ruleset-zally"})
public final class NoUnusedDefinitionsRule {
    @Check(severity=Severity.SHOULD)
    @NotNull
    public final List<Violation> checkSwagger(@NotNull JsonNode root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Set<JsonPointer> used2 = this.used(root, (Function1<? super JsonNode, ? extends List<? extends JsonPointer>>)((Function1)checkSwagger.used.1.INSTANCE));
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.emptyList(), (Iterable)this.unused(root, "/definitions", "Unused definition", used2)), (Iterable)this.unused(root, "/parameters", "Unused parameter", used2)), (Iterable)this.unused(root, "/responses", "Unused response", used2));
    }

    @Check(severity=Severity.SHOULD)
    @NotNull
    public final List<Violation> checkOpenAPI(@NotNull JsonNode root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Set<JsonPointer> used2 = this.used(root, (Function1<? super JsonNode, ? extends List<? extends JsonPointer>>)((Function1)checkOpenAPI.used.1.INSTANCE));
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.emptyList(), (Iterable)this.unused(root, "/components/schemas", "Unused schema", used2)), (Iterable)this.unused(root, "/components/responses", "Unused response", used2)), (Iterable)this.unused(root, "/components/parameters", "Unused parameter", used2)), (Iterable)this.unused(root, "/components/examples", "Unused example", used2)), (Iterable)this.unused(root, "/components/requestBodies", "Unused request body", used2)), (Iterable)this.unused(root, "/components/headers", "Unused header", used2)), (Iterable)this.unused(root, "/components/links", "Unused link", used2)), (Iterable)this.unused(root, "/components/callbacks", "Unused callback", used2));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<JsonPointer> used(JsonNode node, Function1<? super JsonNode, ? extends List<? extends JsonPointer>> discriminators) {
        Set set;
        if (node.isArray()) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = (Iterable)node;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                JsonNode it = (JsonNode)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                Iterable list$iv$iv = this.used(it, discriminators);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        } else if (node.isObject()) {
            void var3_4;
            void $this$flatMapTo$iv$iv;
            Set references = new LinkedHashSet();
            CollectionsKt.addAll((Collection)references, this.reference(node));
            Collection collection = references;
            List list = (List)discriminators.invoke((Object)node);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            CollectionsKt.addAll((Collection)collection, (Iterable)list);
            Collection collection2 = references;
            Iterable $this$flatMap$iv = (Iterable)node;
            boolean $i$f$flatMap = false;
            Iterable $i$f$flatMapTo = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                JsonNode it = (JsonNode)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                Iterable list$iv$iv = this.used(it, discriminators);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable iterable = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)collection2, (Iterable)iterable);
            set = var3_4;
        } else {
            set = SetsKt.emptySet();
        }
        return set;
    }

    private final Sequence<JsonPointer> reference(JsonNode node) {
        Object[] objectArray = new JsonNode[]{node.get("$ref")};
        return SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.sequenceOf((Object[])objectArray)), (Function1)reference.1.INSTANCE), (Function1)reference.2.INSTANCE), (Function1)reference.3.INSTANCE), (Function1)reference.4.INSTANCE);
    }

    private final List<Violation> unused(JsonNode root, String pointer, String description, Set<? extends JsonPointer> used2) {
        Sequence sequence;
        Sequence sequence2;
        Sequence sequence3;
        Sequence sequence4;
        Iterator iterator;
        JsonPointer ptr = JsonPointerExtensionsKt.toJsonPointer((String)pointer);
        JsonNode jsonNode = root.at(ptr);
        List list = jsonNode != null && (iterator = jsonNode.fieldNames()) != null && (sequence4 = SequencesKt.asSequence((Iterator)iterator)) != null && (sequence3 = SequencesKt.map((Sequence)sequence4, (Function1)((Function1)new Function1<String, JsonPointer>(ptr){
            final /* synthetic */ JsonPointer $ptr;
            {
                this.$ptr = $ptr;
                super(1);
            }

            @NotNull
            public final JsonPointer invoke(String it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return JsonPointerExtensionsKt.plus((JsonPointer)this.$ptr, (JsonPointer)JsonPointerExtensionsKt.toEscapedJsonPointer((String)it));
            }
        }))) != null && (sequence2 = SequencesKt.minus((Sequence)sequence3, (Iterable)used2)) != null && (sequence = SequencesKt.map((Sequence)sequence2, (Function1)((Function1)new Function1<JsonPointer, Violation>(description){
            final /* synthetic */ String $description;
            {
                this.$description = $description;
                super(1);
            }

            @NotNull
            public final Violation invoke(@NotNull JsonPointer it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new Violation(this.$description, it);
            }
        }))) != null ? SequencesKt.toList((Sequence)sequence) : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

