/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zally;

import io.swagger.models.Swagger;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.core.JsonPointerExtensionsKt;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zally.ZallyRuleSet;

@Rule(ruleSet=ZallyRuleSet.class, id="M008", severity=Severity.MUST, title="Host should not contain protocol")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lorg/zalando/zally/ruleset/zally/NoProtocolInHostRule;", "", "()V", "validate", "", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "zally-ruleset-zally"})
public final class NoProtocolInHostRule {
    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> validate(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Swagger swagger = context.getSwagger();
        String string = swagger != null ? swagger.getHost() : null;
        if (string == null) {
            string = "";
        }
        String host = string;
        return context.isOpenAPI3() ? CollectionsKt.emptyList() : (StringsKt.contains$default((CharSequence)host, (CharSequence)"://", (boolean)false, (int)2, null) ? CollectionsKt.listOf((Object)new Violation("'" + host + "' contains protocol information which should be listed separately as schemes", JsonPointerExtensionsKt.toJsonPointer((String)"/host"))) : CollectionsKt.emptyList());
    }
}

