/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zally;

import com.typesafe.config.Config;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.core.CaseChecker;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zally.ZallyRuleSet;

@Rule(ruleSet=ZallyRuleSet.class, id="M010", severity=Severity.MUST, title="Check case of various terms")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/zalando/zally/ruleset/zally/CaseCheckerRule;", "", "config", "Lcom/typesafe/config/Config;", "(Lcom/typesafe/config/Config;)V", "checker", "Lorg/zalando/zally/core/CaseChecker;", "checkDiscriminatorValues", "", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "checkEnumValues", "checkHeaderNames", "checkPathParameterNames", "checkPathSegments", "checkPropertyNames", "checkQueryParameterNames", "checkTagNames", "zally-ruleset-zally"})
public final class CaseCheckerRule {
    @NotNull
    private final CaseChecker checker;

    public CaseCheckerRule(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.checker = CaseChecker.Companion.load(config);
    }

    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> checkPropertyNames(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.checker.checkPropertyNames(context);
    }

    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> checkPathParameterNames(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.checker.checkPathParameterNames(context);
    }

    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> checkQueryParameterNames(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.checker.checkQueryParameterNames(context);
    }

    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> checkHeaderNames(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.checker.checkHeadersNames(context);
    }

    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> checkTagNames(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.checker.checkTagNames(context);
    }

    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> checkPathSegments(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.checker.checkPathSegments(context);
    }

    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> checkDiscriminatorValues(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.checker.checkDiscriminatorValues(context);
    }

    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> checkEnumValues(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.checker.checkEnumValues(context);
    }
}

