/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zally;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.core.JsonPointerExtensionsKt;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zally.AvoidXZallyIgnoreRule;
import org.zalando.zally.ruleset.zally.ZallyRuleSet;

@Rule(ruleSet=ZallyRuleSet.class, id="H002", severity=Severity.HINT, title="Avoid using x-zally-ignore extension.")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0007J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0002J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0002J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0002J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/zalando/zally/ruleset/zally/AvoidXZallyIgnoreRule;", "", "()V", "xZallyIgnore", "", "validate", "", "Lorg/zalando/zally/rule/api/Violation;", "root", "Lcom/fasterxml/jackson/databind/JsonNode;", "validateArrayNode", "pointer", "Lcom/fasterxml/jackson/core/JsonPointer;", "node", "validateObjectNode", "validateTree", "validateXZallyIgnore", "zally-ruleset-zally"})
public final class AvoidXZallyIgnoreRule {
    @NotNull
    private final String xZallyIgnore;

    public AvoidXZallyIgnoreRule() {
        this.xZallyIgnore = "x-zally-ignore";
    }

    @Check(severity=Severity.HINT)
    @NotNull
    public final List<Violation> validate(@NotNull JsonNode root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return this.validateTree(JsonPointerExtensionsKt.getEMPTY_JSON_POINTER(), root);
    }

    private final List<Violation> validateTree(JsonPointer pointer, JsonNode node) {
        return node.isArray() ? this.validateArrayNode(pointer, node) : (node.isObject() ? this.validateObjectNode(pointer, node) : CollectionsKt.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    private final List<Violation> validateArrayNode(JsonPointer pointer, JsonNode node) {
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv = SequencesKt.toList((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)node)));
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void childNode;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            JsonNode jsonNode = (JsonNode)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            JsonPointer childPointer = JsonPointerExtensionsKt.plus((JsonPointer)pointer, (JsonPointer)JsonPointerExtensionsKt.toJsonPointer((String)("/" + (int)index)));
            Intrinsics.checkNotNullExpressionValue((Object)childNode, (String)"childNode");
            collection.add(this.validateTree(childPointer, (JsonNode)childNode));
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Violation> validateObjectNode(JsonPointer pointer, JsonNode node) {
        void $this$flatMapTo$iv$iv;
        Iterator iterator = node.fields();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"node.fields()");
        Iterable $this$flatMap$iv = SequencesKt.toList((Sequence)SequencesKt.asSequence((Iterator)iterator));
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List<Violation> list;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"(name, childNode)");
            String name = (String)entry.getKey();
            JsonNode childNode = (JsonNode)entry.getValue();
            if (Intrinsics.areEqual((Object)name, (Object)this.xZallyIgnore)) {
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                JsonPointer jsonPointer = JsonPointerExtensionsKt.plus((JsonPointer)pointer, (JsonPointer)JsonPointerExtensionsKt.toEscapedJsonPointer((String)name));
                Intrinsics.checkNotNullExpressionValue((Object)childNode, (String)"childNode");
                list = this.validateXZallyIgnore(jsonPointer, childNode);
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                JsonPointer jsonPointer = JsonPointerExtensionsKt.plus((JsonPointer)pointer, (JsonPointer)JsonPointerExtensionsKt.toEscapedJsonPointer((String)name));
                Intrinsics.checkNotNullExpressionValue((Object)childNode, (String)"childNode");
                list = this.validateTree(jsonPointer, childNode);
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<Violation> validateXZallyIgnore(JsonPointer pointer, JsonNode node) {
        return CollectionsKt.listOf((Object)new Violation((String)(node.isArray() ? CollectionsKt.joinToString$default((Iterable)((Iterable)node), (CharSequence)", ", (CharSequence)"Ignores rules ", null, (int)0, null, (Function1)validateXZallyIgnore.1.INSTANCE, (int)28, null) : (node.isValueNode() ? "Invalid ignores, expected list but found single value " + node : "Invalid ignores, expected list but found " + node)), pointer));
    }
}

