/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.stups.oauth2.spring.server;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.util.StringUtils;
import org.zalando.stups.oauth2.spring.server.AuthenticationExtractor;

public abstract class AbstractAuthenticationExtractor
implements AuthenticationExtractor {
    private static final String UID_SCOPE = "uid";
    private boolean throwExceptionOnEmptyUid = true;

    @Override
    public OAuth2Authentication extractAuthentication(Map<String, Object> map, String clientId) {
        UsernamePasswordAuthenticationToken user = new UsernamePasswordAuthenticationToken(this.getPrincipal(map), (Object)"N/A", (Collection)AuthorityUtils.commaSeparatedStringToAuthorityList((String)"ROLE_USER"));
        user.setDetails(map);
        Set<String> scopes = this.resolveScopes(map);
        OAuth2Request request = new OAuth2Request(null, clientId, null, true, scopes, null, null, null, null);
        return new OAuth2Authentication(request, (Authentication)user);
    }

    protected abstract Set<String> resolveScopes(Map<String, Object> var1);

    protected Set<String> validateUidScope(Set<String> scopes, Map<String, Object> map) {
        HashSet<String> result = new HashSet<String>(scopes);
        String uidValue = (String)map.get(UID_SCOPE);
        if (StringUtils.hasText((String)uidValue)) {
            result.add(UID_SCOPE);
        } else if (this.isThrowExceptionOnEmptyUid()) {
            throw new InvalidTokenException("'uid' in accessToken should never be empty!");
        }
        return result;
    }

    protected Object getPrincipal(Map<String, Object> map) {
        for (String key : this.getPossibleUserIdKeys()) {
            if (!map.containsKey(key)) continue;
            return map.get(key);
        }
        throw new InvalidTokenException("No 'uid'-scope found in access-token!");
    }

    protected String[] getPossibleUserIdKeys() {
        return new String[]{UID_SCOPE};
    }

    public boolean isThrowExceptionOnEmptyUid() {
        return this.throwExceptionOnEmptyUid;
    }

    public void setThrowExceptionOnEmptyUid(boolean throwExceptionOnEmptyUid) {
        this.throwExceptionOnEmptyUid = throwExceptionOnEmptyUid;
    }
}

