/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.httpclient.metrics;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import lombok.Generated;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.core5.pool.PoolStats;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL)
public final class HttpConnectionPoolMetrics
implements MeterBinder {
    private static final String CONNECTIONS = "connections";
    private static final String REQUESTS = "requests";
    private final Supplier<PoolStats> stats;
    private final String metricName;
    private final ImmutableList<Tag> defaultTags;

    public HttpConnectionPoolMetrics(PoolingHttpClientConnectionManager manager) {
        this(manager, "http.client.connections", (ImmutableList<Tag>)ImmutableList.of());
    }

    private HttpConnectionPoolMetrics(PoolingHttpClientConnectionManager manager, String metricName, ImmutableList<Tag> defaultTags) {
        this((Supplier<PoolStats>)Suppliers.memoizeWithExpiration(() -> ((PoolingHttpClientConnectionManager)manager).getTotalStats(), (long)1L, (TimeUnit)TimeUnit.MINUTES), metricName, defaultTags);
    }

    public HttpConnectionPoolMetrics withMetricName(String metricName) {
        return new HttpConnectionPoolMetrics(this.stats, metricName, this.defaultTags);
    }

    public HttpConnectionPoolMetrics withDefaultTags(Tag ... defaultTags) {
        return this.withDefaultTags((Iterable<Tag>)ImmutableList.copyOf((Object[])defaultTags));
    }

    public HttpConnectionPoolMetrics withDefaultTags(Iterable<Tag> defaultTags) {
        return new HttpConnectionPoolMetrics(this.stats, this.metricName, (ImmutableList<Tag>)ImmutableList.copyOf(defaultTags));
    }

    public void bindTo(MeterRegistry registry) {
        this.gauge("available", PoolStats::getAvailable).description("The number idle connections").baseUnit(CONNECTIONS).register(registry);
        this.gauge("leased", PoolStats::getLeased).description("The number of connections that are actively executing requests").baseUnit(CONNECTIONS).register(registry);
        this.gauge("total", stats -> stats.getAvailable() + stats.getLeased()).description("The number of connections that are currently in the pool").baseUnit(CONNECTIONS).register(registry);
        this.gauge("min", stats -> 0).description("The minimum number of connections in the pool").baseUnit(CONNECTIONS).register(registry);
        this.gauge("max", PoolStats::getMax).description("The maximum number of connections in the pool").baseUnit(CONNECTIONS).register(registry);
        this.gauge("queued", PoolStats::getPending).description("The number of queued connection lease requests").baseUnit(REQUESTS).register(registry);
    }

    private Gauge.Builder<Supplier<Number>> gauge(String name, ToIntFunction<PoolStats> function) {
        return Gauge.builder((String)(this.metricName + "." + name), () -> function.applyAsInt(this.stats.get())).tags(this.defaultTags);
    }

    @Generated
    private HttpConnectionPoolMetrics(Supplier<PoolStats> stats, String metricName, ImmutableList<Tag> defaultTags) {
        this.stats = stats;
        this.metricName = metricName;
        this.defaultTags = defaultTags;
    }
}

