/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.httpclient;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

final class EndOfStreamAwareInputStream
extends FilterInputStream {
    private final Closer closer;
    private boolean endOfStreamDetected;

    EndOfStreamAwareInputStream(InputStream in, Closer closer) {
        super(in);
        this.closer = closer;
    }

    @Override
    public int read() throws IOException {
        return this.detectEndOfStream(super.read());
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.detectEndOfStream(super.read(b));
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.detectEndOfStream(super.read(b, off, len));
    }

    private int detectEndOfStream(int read) {
        if (read == -1) {
            this.endOfStreamDetected = true;
        }
        return read;
    }

    @Override
    public void close() throws IOException {
        this.closer.close(this.in, this.endOfStreamDetected);
    }

    @FunctionalInterface
    static interface Closer {
        public void close(InputStream var1, boolean var2) throws IOException;
    }
}

