/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.httpclient;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.MimeType;
import org.zalando.riptide.httpclient.ApacheClientHttpResponse;
import org.zalando.riptide.httpclient.Headers;

final class BufferingApacheClientHttpRequest
implements ClientHttpRequest {
    private final HttpHeaders headers = new HttpHeaders();
    private final ByteArrayOutputStream output = new ByteArrayOutputStream(1024);
    private final HttpClient client;
    private final HttpUriRequest request;

    @Nonnull
    public HttpMethod getMethod() {
        return HttpMethod.valueOf((String)this.request.getMethod());
    }

    @Nonnull
    public URI getURI() {
        try {
            return this.request.getUri();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Nonnull
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Nonnull
    public OutputStream getBody() {
        return this.output;
    }

    @Nonnull
    public ClientHttpResponse execute() throws IOException {
        Headers.writeHeaders(this.headers, this.request);
        this.request.setEntity((HttpEntity)new ByteArrayEntity(this.output.toByteArray(), this.toContentType(this.headers.getContentType())));
        ClassicHttpResponse response = this.client.executeOpen(null, (ClassicHttpRequest)this.request, null);
        return new ApacheClientHttpResponse((HttpResponse)response);
    }

    @Nullable
    private ContentType toContentType(@Nullable MediaType mediaType) {
        return Optional.ofNullable(mediaType).map(MimeType::toString).map(ContentType::create).orElse(null);
    }

    @Generated
    public BufferingApacheClientHttpRequest(HttpClient client, HttpUriRequest request) {
        this.client = client;
        this.request = request;
    }
}

