/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.httpclient;

import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpOptions;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpTrace;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apiguardian.api.API;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.zalando.riptide.httpclient.BufferingApacheClientHttpRequest;
import org.zalando.riptide.httpclient.StreamingApacheClientHttpRequest;

@API(status=API.Status.STABLE)
public final class ApacheClientHttpRequestFactory
implements ClientHttpRequestFactory,
DisposableBean {
    private final Map<HttpMethod, Function<URI, HttpUriRequest>> methods = ImmutableMap.builder().put((Object)HttpMethod.GET, HttpGet::new).put((Object)HttpMethod.HEAD, HttpHead::new).put((Object)HttpMethod.POST, HttpPost::new).put((Object)HttpMethod.PUT, HttpPut::new).put((Object)HttpMethod.PATCH, HttpPatch::new).put((Object)HttpMethod.DELETE, HttpDelete::new).put((Object)HttpMethod.OPTIONS, HttpOptions::new).put((Object)HttpMethod.TRACE, HttpTrace::new).build();
    private final HttpClient client;
    private final Mode mode;

    public ApacheClientHttpRequestFactory(CloseableHttpClient client) {
        this((HttpClient)client, Mode.STREAMING);
    }

    public ClientHttpRequest createRequest(URI uri, HttpMethod method) {
        HttpUriRequest request = this.methods.get(method).apply(uri);
        if (this.mode == Mode.STREAMING) {
            return new StreamingApacheClientHttpRequest(this.client, request);
        }
        return new BufferingApacheClientHttpRequest(this.client, request);
    }

    public void destroy() throws IOException {
        if (this.client instanceof Closeable) {
            Closeable closeable = (Closeable)this.client;
            closeable.close();
        }
    }

    @Generated
    public ApacheClientHttpRequestFactory(HttpClient client, Mode mode) {
        this.client = client;
        this.mode = mode;
    }

    public static enum Mode {
        STREAMING,
        BUFFERING;

    }
}

