/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem.spring.webflux.advice;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.annotation.Nonnull;
import org.springframework.http.ResponseEntity;
import org.springframework.web.server.MethodNotAllowedException;
import org.springframework.web.server.NotAcceptableStatusException;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.UnsupportedMediaTypeStatusException;
import org.springframework.web.server.WebExceptionHandler;
import org.zalando.problem.Problem;
import org.zalando.problem.spring.webflux.advice.http.HttpAdviceTrait;
import org.zalando.problem.spring.webflux.advice.utils.AdviceUtils;
import reactor.core.publisher.Mono;

public class ProblemExceptionHandler
implements WebExceptionHandler {
    private final ObjectMapper mapper;
    private final HttpAdviceTrait advice;

    public ProblemExceptionHandler(ObjectMapper mapper, HttpAdviceTrait advice) {
        this.mapper = mapper;
        this.advice = advice;
    }

    @Nonnull
    public Mono<Void> handle(ServerWebExchange exchange, Throwable throwable) {
        if (throwable instanceof ResponseStatusException) {
            Mono<ResponseEntity<Problem>> entityMono = this.find(exchange, throwable);
            return entityMono.flatMap(entity -> AdviceUtils.setHttpResponse((ResponseEntity<Problem>)entity, exchange, this.mapper));
        }
        return Mono.error((Throwable)throwable);
    }

    private Mono<ResponseEntity<Problem>> find(ServerWebExchange exchange, Throwable throwable) {
        if (throwable instanceof NotAcceptableStatusException) {
            return this.advice.handleMediaTypeNotAcceptable((NotAcceptableStatusException)throwable, exchange);
        }
        if (throwable instanceof UnsupportedMediaTypeStatusException) {
            return this.advice.handleMediaTypeNotSupportedException((UnsupportedMediaTypeStatusException)throwable, exchange);
        }
        if (throwable instanceof MethodNotAllowedException) {
            return this.advice.handleRequestMethodNotSupportedException((MethodNotAllowedException)throwable, exchange);
        }
        return this.advice.handleResponseStatusException((ResponseStatusException)throwable, exchange);
    }
}

