/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.autoconfigure.webflux;

import io.netty.channel.ChannelHandler;
import org.apiguardian.api.API;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.reactive.function.client.ReactorNettyHttpClientMapper;
import org.springframework.boot.web.embedded.netty.NettyServerCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.server.WebFilter;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.netty.LogbookClientHandler;
import org.zalando.logbook.netty.LogbookServerHandler;
import org.zalando.logbook.spring.webflux.LogbookExchangeFilterFunction;
import org.zalando.logbook.spring.webflux.LogbookWebFilter;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.server.HttpServer;

@API(status=API.Status.EXPERIMENTAL)
@Configuration(proxyBeanMethods=false)
public class LogbookWebFluxAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingClass(value={"reactor.netty.http.client.HttpClient"})
    static class WebFluxClientConfiguration {
        static final String CUSTOMIZER_NAME = "logbookClientExchangeFunction";

        WebFluxClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"logbookClientExchangeFunction"})
        public ExchangeFilterFunction logbookClientExchangeFunction(Logbook logbook) {
            return new LogbookExchangeFilterFunction(logbook);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HttpClient.class})
    static class WebFluxNettyClientConfiguration {
        static final String CUSTOMIZER_NAME = "logbookNettyClientCustomizer";

        WebFluxNettyClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"logbookNettyClientCustomizer"})
        public ReactorNettyHttpClientMapper logbookNettyClientCustomizer(Logbook logbook) {
            return httpClient -> (HttpClient)httpClient.doOnConnected(connection -> connection.addHandlerLast((ChannelHandler)new LogbookClientHandler(logbook)));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingClass(value={"reactor.netty.http.server.HttpServer"})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    static class WebFluxServerConfiguration {
        static final String CUSTOMIZER_NAME = "logbookServerFilter";

        WebFluxServerConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(name={"logbook.filter.enabled"}, havingValue="true", matchIfMissing=true)
        @ConditionalOnMissingBean(name={"logbookServerFilter"})
        public WebFilter logbookServerFilter(Logbook logbook) {
            return new LogbookWebFilter(logbook);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HttpServer.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    static class WebFluxNettyServerConfiguration {
        static final String CUSTOMIZER_NAME = "logbookNettyServerCustomizer";

        WebFluxNettyServerConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(name={"logbook.filter.enabled"}, havingValue="true", matchIfMissing=true)
        @ConditionalOnMissingBean(name={"logbookNettyServerCustomizer"})
        public NettyServerCustomizer logbookNettyServerCustomizer(Logbook logbook) {
            return httpServer -> (HttpServer)httpServer.doOnConnection(connection -> connection.addHandlerLast((ChannelHandler)new LogbookServerHandler(logbook)));
        }
    }
}

