/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.okhttp;

import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.RealResponseBody;
import okio.GzipSource;
import okio.Okio;
import okio.Source;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL)
public final class GzipInterceptor
implements Interceptor {
    @Nonnull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response = chain.proceed(chain.request());
        if (this.isContentEncodingGzip(response)) {
            return response.newBuilder().headers(response.headers().newBuilder().removeAll("Content-Encoding").removeAll("Content-Length").build()).body((ResponseBody)new RealResponseBody(response.header("Content-Type"), -1L, Okio.buffer((Source)new GzipSource((Source)Objects.requireNonNull(response.body(), "body").source())))).build();
        }
        return response;
    }

    private boolean isContentEncodingGzip(Response response) {
        return "gzip".equalsIgnoreCase(response.header("Content-Encoding"));
    }
}

