/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.jaxrs;

import java.io.IOException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.zalando.fauxpas.FauxPas;
import org.zalando.logbook.Correlator;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.RawHttpRequest;
import org.zalando.logbook.RawHttpResponse;
import org.zalando.logbook.jaxrs.Attributes;
import org.zalando.logbook.jaxrs.LocalResponse;
import org.zalando.logbook.jaxrs.RemoteRequest;

@Provider
@ConstrainedTo(value=RuntimeType.SERVER)
public final class LogbookServerFilter
implements ContainerRequestFilter,
ContainerResponseFilter,
WriterInterceptor {
    private final Logbook logbook;

    public LogbookServerFilter(Logbook logbook) {
        this.logbook = logbook;
    }

    public void filter(ContainerRequestContext context) throws IOException {
        this.logbook.write((RawHttpRequest)new RemoteRequest(context)).ifPresent(correlator -> context.setProperty(Attributes.CORRELATOR, correlator));
    }

    public void filter(ContainerRequestContext request, ContainerResponseContext response) {
        LocalResponse rawHttpResponse = new LocalResponse(response);
        if (response.hasEntity()) {
            request.setProperty(Attributes.RESPONSE, (Object)rawHttpResponse);
        } else {
            LogbookServerFilter.read(arg_0 -> ((ContainerRequestContext)request).getProperty(arg_0), Attributes.CORRELATOR, Correlator.class).ifPresent((Consumer<Correlator>)FauxPas.throwingConsumer(correlator -> correlator.write(rawHttpResponse)));
        }
    }

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException {
        context.proceed();
        LogbookServerFilter.read(arg_0 -> ((WriterInterceptorContext)context).getProperty(arg_0), Attributes.CORRELATOR, Correlator.class).ifPresent((Consumer<Correlator>)FauxPas.throwingConsumer(correlator -> LogbookServerFilter.read(arg_0 -> ((WriterInterceptorContext)context).getProperty(arg_0), Attributes.RESPONSE, RawHttpResponse.class).ifPresent((Consumer<RawHttpResponse>)FauxPas.throwingConsumer(arg_0 -> ((Correlator)correlator).write(arg_0)))));
    }

    private static <T> Optional<T> read(Function<String, Object> provider, String name, Class<T> type) {
        return Optional.ofNullable(provider.apply(name)).map(type::cast);
    }
}

