/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.httpclient5;

import java.io.IOException;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.httpclient5.LocalRequest;
import org.zalando.logbook.httpclient5.RemoteResponse;

public class LogbookHttpExecHandler
implements ExecChainHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogbookHttpExecHandler.class);
    private final Logbook logbook;

    public LogbookHttpExecHandler(Logbook logbook) {
        this.logbook = logbook;
    }

    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain execChain) throws IOException, HttpException {
        Logbook.ResponseProcessingStage stage = this.logRequest(request);
        ClassicHttpResponse response = execChain.proceed(request, scope);
        LogbookHttpExecHandler.logResponse(stage, response);
        return response;
    }

    @Nullable
    private Logbook.ResponseProcessingStage logRequest(ClassicHttpRequest request) {
        Logbook.ResponseProcessingStage stage = null;
        try {
            LocalRequest localRequest = new LocalRequest((org.apache.hc.core5.http.HttpRequest)request, (EntityDetails)request.getEntity());
            stage = this.logbook.process((HttpRequest)localRequest).write();
        }
        catch (Exception e) {
            log.warn("Unable to log request. Will skip the request & response logging step.", (Throwable)e);
        }
        return stage;
    }

    private static void logResponse(@Nullable Logbook.ResponseProcessingStage stage, ClassicHttpResponse response) {
        if (stage != null) {
            try {
                stage.process((HttpResponse)new RemoteResponse((org.apache.hc.core5.http.HttpResponse)response)).write();
            }
            catch (Exception e) {
                log.warn("Unable to log response. Will skip the response logging step.", (Throwable)e);
            }
        } else {
            log.warn("Unable to log response: ResponseProcessingStage is null. Will skip the response logging step.");
        }
    }
}

