/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.httpclient;

import java.io.IOException;
import lombok.Generated;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.httpclient.Attributes;
import org.zalando.logbook.httpclient.RemoteResponse;

@API(status=API.Status.STABLE)
public final class LogbookHttpResponseInterceptor
implements HttpResponseInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogbookHttpResponseInterceptor.class);
    private final boolean decompressResponse;

    public LogbookHttpResponseInterceptor() {
        this(false);
    }

    public LogbookHttpResponseInterceptor(boolean decompressResponse) {
        this.decompressResponse = decompressResponse;
    }

    public void process(org.apache.http.HttpResponse original, HttpContext context) throws IOException {
        try {
            this.doProcess(original, context);
        }
        catch (Exception e) {
            log.warn("Unable to log response. Will skip the response logging step.", (Throwable)e);
        }
    }

    private void doProcess(org.apache.http.HttpResponse original, HttpContext context) throws IOException {
        Logbook.ResponseProcessingStage stage = this.find(context);
        if (stage != null) {
            stage.process((HttpResponse)new RemoteResponse(original, this.decompressResponse)).write();
        } else {
            log.warn("Unable to log response: ResponseProcessingStage is null in HttpContext. Will skip the response logging step.");
        }
    }

    private Logbook.ResponseProcessingStage find(HttpContext context) {
        return (Logbook.ResponseProcessingStage)context.getAttribute(Attributes.STAGE);
    }
}

