/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.httpclient;

import java.io.IOException;
import lombok.Generated;
import org.apache.http.HttpException;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.httpclient.Attributes;
import org.zalando.logbook.httpclient.ForwardingHttpAsyncResponseConsumer;
import org.zalando.logbook.httpclient.RemoteResponse;

@API(status=API.Status.EXPERIMENTAL)
public final class LogbookHttpAsyncResponseConsumer<T>
extends ForwardingHttpAsyncResponseConsumer<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogbookHttpAsyncResponseConsumer.class);
    private final HttpAsyncResponseConsumer<T> consumer;
    private final boolean decompressResponse;
    private org.apache.http.HttpResponse response;

    public LogbookHttpAsyncResponseConsumer(HttpAsyncResponseConsumer<T> consumer, boolean decompressResponse) {
        this.consumer = consumer;
        this.decompressResponse = decompressResponse;
    }

    @Override
    protected HttpAsyncResponseConsumer<T> delegate() {
        return this.consumer;
    }

    @Override
    public void responseReceived(org.apache.http.HttpResponse response) throws IOException, HttpException {
        this.response = response;
        this.delegate().responseReceived(response);
    }

    @Override
    public void responseCompleted(HttpContext context) {
        Logbook.ResponseProcessingStage stage = this.find(context);
        try {
            if (stage != null) {
                stage.process((HttpResponse)new RemoteResponse(this.response, this.decompressResponse)).write();
            } else {
                log.warn("Unable to log response: ResponseProcessingStage is null in HttpContext. Will skip the response logging step.");
            }
        }
        catch (IOException e) {
            log.warn("Unable to log response. Will skip the response logging step.", (Throwable)e);
        }
        this.delegate().responseCompleted(context);
    }

    private Logbook.ResponseProcessingStage find(HttpContext context) {
        return (Logbook.ResponseProcessingStage)context.getAttribute(Attributes.STAGE);
    }
}

