/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.httpclient;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.zalando.fauxpas.FauxPas;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.Origin;
import org.zalando.logbook.httpclient.HttpEntities;

final class LocalRequest
implements HttpRequest {
    private final AtomicReference<State> state = new AtomicReference<Unbuffered>(new Unbuffered());
    private final org.apache.http.HttpRequest request;
    private final URI originalRequestUri;

    LocalRequest(org.apache.http.HttpRequest request) {
        this.request = request;
        this.originalRequestUri = LocalRequest.getOriginalRequestUri(request);
    }

    private static URI getOriginalRequestUri(org.apache.http.HttpRequest request) {
        if (request instanceof HttpRequestWrapper) {
            return LocalRequest.extractRequestUri(((HttpRequestWrapper)HttpRequestWrapper.class.cast(request)).getOriginal());
        }
        if (request instanceof HttpUriRequest) {
            return ((HttpUriRequest)HttpUriRequest.class.cast(request)).getURI();
        }
        return LocalRequest.extractRequestUri(request);
    }

    private static URI extractRequestUri(org.apache.http.HttpRequest request) {
        return URI.create(request.getRequestLine().getUri());
    }

    public Origin getOrigin() {
        return Origin.LOCAL;
    }

    public String getProtocolVersion() {
        return this.request.getRequestLine().getProtocolVersion().toString();
    }

    public String getRemote() {
        return "localhost";
    }

    public String getMethod() {
        return this.request.getRequestLine().getMethod();
    }

    public String getScheme() {
        return this.originalRequestUri.getScheme();
    }

    public String getHost() {
        return this.originalRequestUri.getHost();
    }

    public Optional<Integer> getPort() {
        return Optional.of(this.originalRequestUri.getPort()).filter(p -> p != -1);
    }

    public String getPath() {
        return this.originalRequestUri.getPath();
    }

    public String getQuery() {
        return Optional.ofNullable(this.originalRequestUri.getQuery()).orElse("");
    }

    public HttpHeaders getHeaders() {
        HttpHeaders headers = HttpHeaders.empty();
        Set entries = Stream.of(this.request.getAllHeaders()).collect(Collectors.groupingBy(NameValuePair::getName, Collectors.mapping(NameValuePair::getValue, Collectors.toList()))).entrySet();
        for (Map.Entry entry : entries) {
            String name = entry.getKey();
            List values = entry.getValue();
            headers = headers.update(name, values);
        }
        return headers;
    }

    public String getContentType() {
        return Optional.of(this.request).map(request -> request.getFirstHeader("Content-Type")).map(NameValuePair::getValue).orElse("");
    }

    public Charset getCharset() {
        return Optional.of(this.request).map(request -> request.getFirstHeader("Content-Type")).map(NameValuePair::getValue).map(ContentType::parse).map(ContentType::getCharset).orElse(StandardCharsets.UTF_8);
    }

    public HttpRequest withBody() {
        this.state.updateAndGet(State::with);
        return this;
    }

    public HttpRequest withoutBody() {
        this.state.updateAndGet(State::without);
        return this;
    }

    public byte[] getBody() {
        return this.state.updateAndGet((UnaryOperator<State>)FauxPas.throwingUnaryOperator(state -> state.buffer(this.request))).getBody();
    }

    private static final class Passing
    implements State {
        private Passing() {
        }
    }

    private static final class Ignoring
    implements State {
        private final Buffering buffering;

        @Override
        public State with() {
            return this.buffering;
        }

        @Generated
        public Ignoring(Buffering buffering) {
            this.buffering = buffering;
        }
    }

    private static final class Buffering
    implements State {
        private final byte[] body;

        @Override
        public State without() {
            return new Ignoring(this);
        }

        @Override
        public byte[] getBody() {
            return this.body;
        }

        @Generated
        public Buffering(byte[] body) {
            this.body = body;
        }
    }

    private static final class Offering
    implements State {
        private Offering() {
        }

        @Override
        public State without() {
            return new Unbuffered();
        }

        @Override
        public State buffer(org.apache.http.HttpRequest request) throws IOException {
            if (request instanceof HttpEntityEnclosingRequest) {
                HttpEntityEnclosingRequest original = (HttpEntityEnclosingRequest)request;
                HttpEntity entity = original.getEntity();
                if (entity == null) {
                    return new Passing();
                }
                HttpEntities.Copy copy = HttpEntities.copy(entity);
                original.setEntity((HttpEntity)copy);
                return new Buffering(copy.getBody());
            }
            return new Passing();
        }
    }

    private static final class Unbuffered
    implements State {
        private Unbuffered() {
        }

        @Override
        public State with() {
            return new Offering();
        }
    }

    private static interface State {
        default public State with() {
            return this;
        }

        default public State without() {
            return this;
        }

        default public State buffer(org.apache.http.HttpRequest request) throws IOException {
            return this;
        }

        default public byte[] getBody() {
            return new byte[0];
        }
    }
}

