/*
 * Decompiled with CFR 0.152.
 */
package org.yetiz.lib.acd.api.v1;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ning.http.client.Request;
import com.ning.http.client.Response;
import java.util.ArrayList;
import java.util.List;
import org.yetiz.lib.acd.ACDSession;
import org.yetiz.lib.acd.Entity.AssetInfo;
import org.yetiz.lib.acd.Entity.FileInfo;
import org.yetiz.lib.acd.Entity.FolderInfo;
import org.yetiz.lib.acd.Entity.NodeInfo;
import org.yetiz.lib.acd.Entity.NodeInfoList;
import org.yetiz.lib.acd.Utils;
import org.yetiz.lib.utils.Log;

public class Trash {
    private static String root = "trash";

    public static NodeInfo moveNodeToTrash(ACDSession acdSession, NodeInfo node) {
        Log.d(Utils.getCurrentMethodName());
        String resourceEndpoint = Utils.stringFormatter("{}/{}", root, node.getId());
        Request request = Utils.newFollowRedirectRequestBuilder().setUrl(acdSession.getMetadataUrl(resourceEndpoint)).setBody("{}").setMethod("PUT").build();
        Response response = acdSession.execute(request);
        String kind = ((JsonObject)new JsonParser().parse(Utils.getResponseBody(response))).get("kind").getAsString();
        NodeInfo rtnNodeInfo = null;
        if (kind.equals("FILE")) {
            rtnNodeInfo = (NodeInfo)Utils.getGson().fromJson(Utils.getResponseBody(response), FileInfo.class);
        }
        if (kind.equals("FOLDER")) {
            rtnNodeInfo = (NodeInfo)Utils.getGson().fromJson(Utils.getResponseBody(response), FolderInfo.class);
        }
        if (kind.equals("ASSET")) {
            rtnNodeInfo = (NodeInfo)Utils.getGson().fromJson(Utils.getResponseBody(response), AssetInfo.class);
        }
        return rtnNodeInfo;
    }

    public static NodeInfoList getNodeList(ACDSession acdSession, String startToken) {
        Log.d(Utils.getCurrentMethodName());
        String resourceEndpoint = root;
        if (startToken != null) {
            resourceEndpoint = Utils.stringFormatter("{}&startToken={}", resourceEndpoint, startToken);
        }
        Response response = acdSession.execute(Utils.newFollowRedirectRequestBuilder().setUrl(acdSession.getMetadataUrl(resourceEndpoint)).setMethod("GET").build());
        JsonObject responseObject = (JsonObject)new JsonParser().parse(Utils.getResponseBody(response));
        ArrayList<NodeInfo> data = new ArrayList<NodeInfo>();
        for (JsonObject object : responseObject.get("data").getAsJsonArray()) {
            String kind = object.get("kind").getAsString();
            if (kind.equals("FILE")) {
                data.add((NodeInfo)Utils.getGson().fromJson((JsonElement)object, FileInfo.class));
            }
            if (kind.equals("FOLDER")) {
                data.add((NodeInfo)Utils.getGson().fromJson((JsonElement)object, FolderInfo.class));
            }
            if (!kind.equals("ASSET")) continue;
            data.add((NodeInfo)Utils.getGson().fromJson((JsonElement)object, AssetInfo.class));
        }
        NodeInfoList nodeInfoList = new NodeInfoList((Long)responseObject.get("count").getAsLong(), responseObject.has("nextToken") ? responseObject.get("nextToken").getAsString() : "", (List<NodeInfo>)data);
        return nodeInfoList;
    }

    public static NodeInfo restore(ACDSession acdSession, NodeInfo node) {
        Log.d(Utils.getCurrentMethodName());
        String resourceEndpoint = Utils.stringFormatter("{}/{}/restore", root, node.getId());
        Request request = Utils.newFollowRedirectRequestBuilder().setUrl(acdSession.getMetadataUrl(resourceEndpoint)).setMethod("POST").build();
        Response response = acdSession.execute(request);
        String kind = ((JsonObject)new JsonParser().parse(Utils.getResponseBody(response))).get("kind").getAsString();
        NodeInfo rtnNodeInfo = null;
        if (kind.equals("FILE")) {
            rtnNodeInfo = (NodeInfo)Utils.getGson().fromJson(Utils.getResponseBody(response), FileInfo.class);
        }
        if (kind.equals("FOLDER")) {
            rtnNodeInfo = (NodeInfo)Utils.getGson().fromJson(Utils.getResponseBody(response), FolderInfo.class);
        }
        if (kind.equals("ASSET")) {
            rtnNodeInfo = (NodeInfo)Utils.getGson().fromJson(Utils.getResponseBody(response), AssetInfo.class);
        }
        return rtnNodeInfo;
    }
}

