/*
 * Decompiled with CFR 0.152.
 */
package org.yetiz.lib.acd.api.v1;

import com.ning.http.client.Response;
import org.yetiz.lib.acd.ACDSession;
import org.yetiz.lib.acd.Entity.AccountInfo;
import org.yetiz.lib.acd.Entity.AccountQuota;
import org.yetiz.lib.acd.Entity.AccountUsage;
import org.yetiz.lib.acd.Entity.Endpoint;
import org.yetiz.lib.acd.Utils;
import org.yetiz.lib.utils.Log;

public class Account {
    private static String root = "account";

    public static Endpoint getEndpoint(ACDSession acdSession) {
        Log.d(Utils.getCurrentMethodName());
        String resourceEndpoint = Utils.stringFormatter("{}/endpoint", root);
        Response response = acdSession.execute(Utils.newFollowRedirectRequestBuilder().setUrl(acdSession.getMetadataUrl(resourceEndpoint)).setMethod("GET").build());
        Endpoint endpoint = (Endpoint)Utils.getGson().fromJson(Utils.getResponseBody(response), Endpoint.class);
        return endpoint;
    }

    public static AccountInfo getAccountInfo(ACDSession acdSession) {
        Log.d(Utils.getCurrentMethodName());
        String resourceEndpoint = Utils.stringFormatter("{}/info", root);
        Response response = acdSession.execute(Utils.newFollowRedirectRequestBuilder().setUrl(acdSession.getMetadataUrl(resourceEndpoint)).setMethod("GET").build());
        AccountInfo accountInfo = (AccountInfo)Utils.getGson().fromJson(Utils.getResponseBody(response), AccountInfo.class);
        return accountInfo;
    }

    public static AccountQuota getAccountQuota(ACDSession acdSession) {
        Log.d(Utils.getCurrentMethodName());
        String resourceEndpoint = Utils.stringFormatter("{}/quota", root);
        Response response = acdSession.execute(Utils.newFollowRedirectRequestBuilder().setUrl(acdSession.getMetadataUrl(resourceEndpoint)).setMethod("GET").build());
        AccountQuota accountQuota = (AccountQuota)Utils.getGson().fromJson(Utils.getResponseBody(response), AccountQuota.class);
        return accountQuota;
    }

    public static AccountUsage getAccountUsage(ACDSession acdSession) {
        Log.d(Utils.getCurrentMethodName());
        String resourceEndpoint = Utils.stringFormatter("{}/usage", root);
        Response response = acdSession.execute(Utils.newFollowRedirectRequestBuilder().setUrl(acdSession.getMetadataUrl(resourceEndpoint)).setMethod("GET").build());
        AccountUsage accountUsage = (AccountUsage)Utils.getGson().fromJson(Utils.getResponseBody(response), AccountUsage.class);
        return accountUsage;
    }
}

