/*
 * Decompiled with CFR 0.152.
 */
package org.yetiz.lib.acd;

import com.google.gson.JsonObject;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import java.util.Calendar;
import org.yetiz.lib.acd.ACDToken;
import org.yetiz.lib.acd.Configure;
import org.yetiz.lib.acd.Entity.Endpoint;
import org.yetiz.lib.acd.ResponseCode;
import org.yetiz.lib.acd.Utils;
import org.yetiz.lib.acd.api.v1.Account;
import org.yetiz.lib.acd.exception.ACDResponseException;
import org.yetiz.lib.acd.exception.AuthorizationRequiredException;
import org.yetiz.lib.acd.exception.BadParameterException;
import org.yetiz.lib.acd.exception.InvalidAuthTokenException;
import org.yetiz.lib.utils.Log;

public class ACDSession {
    private AsyncHttpClient asyncHttpClient = null;
    private ACDToken acdToken = null;
    private Configure configure = null;
    private String contentUrl = "";
    private String metadataUrl = "https://drive.amazonaws.com/drive/v1/";

    private ACDSession() {
        AsyncHttpClientConfig asyncHttpClientConfig = new AsyncHttpClientConfig.Builder().setFollowRedirect(false).build();
        this.asyncHttpClient = new AsyncHttpClient(asyncHttpClientConfig);
    }

    public static ACDSession getACDSessionByCode(Configure configure, String code) {
        Response response;
        Log.d(Utils.getCurrentMethodName());
        if (code == null || code == "") {
            throw new AuthorizationRequiredException(configure.getClientId(), configure.getRedirectUri(), configure.isWritable());
        }
        ACDSession acdSession = new ACDSession();
        acdSession.configure = configure;
        try {
            String body = "grant_type=authorization_code&code=" + Utils.urlEncode(code) + "&client_id=" + Utils.urlEncode(configure.getClientId()) + "&client_secret=" + Utils.urlEncode(configure.getClientSecret()) + "&redirect_uri=" + Utils.urlEncode(configure.getRedirectUri());
            response = (Response)acdSession.asyncHttpClient.preparePost("https://api.amazon.com/auth/o2/token").addHeader("Content-Type", "application/x-www-form-urlencoded").setBody(body).execute().get();
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage());
        }
        int statusCode = response.getStatusCode();
        if (statusCode == 400) {
            throw new BadParameterException(response);
        }
        if (statusCode == 200) {
            JsonObject object = Utils.convertBodyToJson(response);
            Integer expires_in = object.get("expires_in").getAsInt();
            String token_type = object.get("token_type").getAsString();
            String refresh_token = object.get("refresh_token").getAsString();
            String access_token = object.get("access_token").getAsString();
            Calendar calendar = Calendar.getInstance();
            calendar.add(13, expires_in);
            acdSession.acdToken = new ACDToken(token_type, calendar.getTime(), refresh_token, access_token);
            acdSession.refreshEndpoint();
            acdSession.updateTokenOfConfigureFile();
        }
        return acdSession;
    }

    public static ACDSession getACDSessionByToken(Configure configure, ACDToken acdToken) {
        Log.d(Utils.getCurrentMethodName());
        if (acdToken == null) {
            throw new NullPointerException("acdToken is not nullable.");
        }
        ACDSession acdSession = new ACDSession();
        acdSession.configure = configure;
        acdSession.acdToken = acdToken;
        if (acdToken.isExpire()) {
            acdSession.refreshToken();
        } else {
            acdSession.refreshEndpoint();
        }
        return acdSession;
    }

    public void refreshToken() {
        Response response;
        Log.d(Utils.getCurrentMethodName());
        try {
            String body = "grant_type=refresh_token&refresh_token=" + Utils.urlEncode(this.acdToken.getRefreshToken()) + "&client_id=" + Utils.urlEncode(this.configure.getClientId()) + "&client_secret=" + Utils.urlEncode(this.configure.getClientSecret());
            response = (Response)this.asyncHttpClient.preparePost("https://api.amazon.com/auth/o2/token").addHeader("Content-Type", "application/x-www-form-urlencoded").setBody(body).execute().get();
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage());
        }
        int statusCode = response.getStatusCode();
        if (statusCode == 400) {
            throw new AuthorizationRequiredException(this.configure.getClientId(), this.configure.getRedirectUri(), this.configure.isWritable());
        }
        if (statusCode != 200) {
            throw new ACDResponseException(response);
        }
        JsonObject object = Utils.convertBodyToJson(response);
        Integer expires_in = object.get("expires_in").getAsInt();
        String token_type = object.get("token_type").getAsString();
        String refresh_token = object.get("refresh_token").getAsString();
        String access_token = object.get("access_token").getAsString();
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, expires_in);
        this.acdToken = new ACDToken(token_type, calendar.getTime(), refresh_token, access_token);
        this.updateTokenOfConfigureFile();
        this.refreshEndpoint();
    }

    public ACDToken getToken() {
        return this.acdToken;
    }

    public Response execute(Request request) {
        Log.d(Utils.getCurrentMethodName());
        if (this.acdToken.isExpire()) {
            this.refreshToken();
        }
        try {
            request = this.setAuthHeader(request);
            long time = System.currentTimeMillis();
            Response response = (Response)this.asyncHttpClient.executeRequest(request).get();
            ResponseCode.check(response);
            Log.d("Execute Time", new Long(System.currentTimeMillis() - time).toString() + "ms");
            return response;
        }
        catch (InvalidAuthTokenException e) {
            if (this.configure.isAutoRefresh().booleanValue()) {
                Log.d("Auto Refresh Token");
                this.refreshToken();
                return this.execute(request);
            }
            throw e;
        }
        catch (ACDResponseException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage());
        }
    }

    private Request setAuthHeader(Request request) {
        return new RequestBuilder(request).setHeader("Authorization", this.acdToken.getAuthorizationString()).build();
    }

    private void updateTokenOfConfigureFile() {
        if (!this.configure.isAutoConfigureUpdate().booleanValue()) {
            return;
        }
        this.configure.setTokenType(this.acdToken.getTokenType());
        this.configure.setAccessToken(this.acdToken.getAccessToken());
        this.configure.setRefreshToken(this.acdToken.getRefreshToken());
        this.configure.save();
    }

    private void refreshEndpoint() {
        Endpoint endpoint = Account.getEndpoint(this);
        this.contentUrl = endpoint.getContentUrl();
        this.metadataUrl = endpoint.getMetadataUrl();
    }

    public String getContentUrl() {
        return this.contentUrl;
    }

    public String getContentUrl(String resourceUrl) {
        return this.getContentUrl() + resourceUrl;
    }

    public String getMetadataUrl() {
        return this.metadataUrl;
    }

    public String getMetadataUrl(String resourceUrl) {
        return this.getMetadataUrl() + resourceUrl;
    }

    public void close() {
        this.destroy();
    }

    public void destroy() {
        this.asyncHttpClient.close();
    }

    public Configure getConfigure() {
        return this.configure;
    }

    public void setConfigure(Configure configure) {
        this.configure = configure;
    }
}

