/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.web;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.yamcs.Plugin;
import org.yamcs.PluginException;
import org.yamcs.YConfiguration;
import org.yamcs.YamcsServer;
import org.yamcs.YamcsServerInstance;
import org.yamcs.api.Api;
import org.yamcs.http.Binding;
import org.yamcs.http.HttpServer;
import org.yamcs.logging.Log;
import org.yamcs.management.ManagementListener;
import org.yamcs.management.ManagementService;
import org.yamcs.protobuf.YamcsInstance;
import org.yamcs.security.SystemPrivilege;
import org.yamcs.templating.ParseException;
import org.yamcs.web.AngularHandler;
import org.yamcs.web.WebApi;
import org.yamcs.web.WebFileDeployer;
import org.yamcs.yarch.Bucket;
import org.yamcs.yarch.YarchDatabase;
import org.yamcs.yarch.YarchDatabaseInstance;

public class WebPlugin
implements Plugin {
    static final String CONFIG_SECTION = "yamcs-web";
    static final String CONFIG_DISPLAY_BUCKET = "displayBucket";
    static final String CONFIG_STACK_BUCKET = "stackBucket";
    public static final SystemPrivilege PRIV_ADMIN = new SystemPrivilege("web.AccessAdminArea");
    private Log log = new Log(this.getClass());
    private WebFileDeployer deployer;
    private AngularHandler angularHandler;
    private List<Path> extraStaticRoots = new ArrayList<Path>();
    private Map<String, Map<String, Object>> extraConfigs = new HashMap<String, Map<String, Object>>();

    public void onLoad(YConfiguration config) throws PluginException {
        YamcsServer yamcs = YamcsServer.getServer();
        yamcs.getSecurityStore().addSystemPrivilege(PRIV_ADMIN);
        HttpServer httpServer = (HttpServer)yamcs.getGlobalService(HttpServer.class);
        String contextPath = httpServer.getContextPath();
        this.createBuckets(config);
        try {
            this.deployer = new WebFileDeployer(config, contextPath, this.extraStaticRoots, this.extraConfigs);
            this.setupRoutes(config, this.deployer);
        }
        catch (IOException | ParseException e) {
            throw new PluginException("Could not deploy website", e);
        }
        yamcs.addReadyListener(() -> {
            for (Binding binding : httpServer.getBindings()) {
                this.log.info("Website deployed at {}{}", new Object[]{binding, contextPath});
            }
        });
    }

    public void addExtension(String id, Map<String, Object> config, Path staticRoot) {
        this.extraConfigs.put(id, config);
        this.extraStaticRoots.add(staticRoot);
        if (this.deployer != null) {
            this.deployer.setExtraSources(this.extraStaticRoots, this.extraConfigs);
            this.angularHandler.setStaticRoots(Stream.concat(Stream.of(this.deployer.getDirectory()), this.deployer.getExtraStaticRoots().stream()).collect(Collectors.toList()));
        }
    }

    private void createBuckets(YConfiguration config) throws PluginException {
        String displayBucketName = config.getString(CONFIG_DISPLAY_BUCKET);
        this.createBucketIfNotExists(displayBucketName);
        String stackBucketName = config.getString(CONFIG_STACK_BUCKET);
        this.createBucketIfNotExists(stackBucketName);
        ManagementService.getInstance().addManagementListener(new ManagementListener(){

            public void instanceStateChanged(YamcsServerInstance ysi) {
                if (ysi.state() == YamcsInstance.InstanceState.STARTING) {
                    String bucketName;
                    YConfiguration instanceConfig = ysi.getConfig().getConfigOrEmpty(WebPlugin.CONFIG_SECTION);
                    if (instanceConfig.containsKey(WebPlugin.CONFIG_DISPLAY_BUCKET)) {
                        bucketName = instanceConfig.getString(WebPlugin.CONFIG_DISPLAY_BUCKET);
                        try {
                            WebPlugin.this.createBucketIfNotExists(bucketName);
                        }
                        catch (PluginException e) {
                            WebPlugin.this.log.error("Could not create display bucket for instance '" + ysi.getName() + "'", (Throwable)e);
                        }
                    }
                    if (instanceConfig.containsKey(WebPlugin.CONFIG_STACK_BUCKET)) {
                        bucketName = instanceConfig.getString(WebPlugin.CONFIG_STACK_BUCKET);
                        try {
                            WebPlugin.this.createBucketIfNotExists(bucketName);
                        }
                        catch (PluginException e) {
                            WebPlugin.this.log.error("Could not create stack bucket for instance '" + ysi.getName() + "'", (Throwable)e);
                        }
                    }
                }
            }
        });
    }

    private Bucket createBucketIfNotExists(String bucketName) throws PluginException {
        YarchDatabaseInstance yarch = YarchDatabase.getInstance((String)"_global");
        try {
            Bucket bucket = yarch.getBucket(bucketName);
            if (bucket == null) {
                bucket = yarch.createBucket(bucketName);
            }
            return bucket;
        }
        catch (IOException e) {
            throw new PluginException("Could not create '" + bucketName + "' bucket", (Throwable)e);
        }
    }

    private void setupRoutes(YConfiguration config, WebFileDeployer deployer) throws PluginException {
        HttpServer httpServer = (HttpServer)YamcsServer.getServer().getGlobalService(HttpServer.class);
        this.angularHandler = new AngularHandler(config, httpServer, deployer.getDirectory(), deployer.getExtraStaticRoots());
        httpServer.addRoute("*", () -> this.angularHandler);
        try (InputStream in = this.getClass().getResourceAsStream("/yamcs-web.protobin");){
            httpServer.getProtobufRegistry().importDefinitions(in);
        }
        catch (IOException e) {
            throw new PluginException((Throwable)e);
        }
        httpServer.addApi((Api)new WebApi());
    }
}

