/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xstream.internal;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.core.ReferenceByXPathMarshaller;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.xstream.internal.SafeWriter;
import org.xwiki.xstream.internal.XStreamUtils;

public class SafeTreeMarshaller
extends ReferenceByXPathMarshaller {
    private static final Logger LOGGER = LoggerFactory.getLogger(SafeTreeMarshaller.class);
    protected SafeWriter safeWriter;
    private final XStreamUtils utils;

    public SafeTreeMarshaller(HierarchicalStreamWriter writer, ConverterLookup converterLookup, Mapper mapper, int mode, XStreamUtils utils) {
        super(writer, converterLookup, mapper, mode);
        this.utils = utils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert(Object item, Converter converter) {
        if (this.utils.isSerializable(item)) {
            HierarchicalStreamWriter currentWriter = this.writer;
            try {
                this.safeWriter = new SafeWriter(this.writer);
                this.writer = this.safeWriter;
                super.convert(item, converter);
            }
            catch (Throwable e) {
                LOGGER.debug("Failed to serialize item [{}]", (Object)(item.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(item))), (Object)e);
                this.safeWriter.fix();
            }
            finally {
                this.writer = currentWriter;
            }
        }
    }
}

