/*
 * Decompiled with CFR 0.152.
 */
package org.xson.logging;

import java.lang.reflect.Constructor;
import org.xson.logging.Log;
import org.xson.logging.LogException;
import org.xson.logging.log4j.Log4jImpl;
import org.xson.logging.slf4j.Slf4jLoggerImpl;

public final class LogFactory {
    public static final String MARKER = "TANGYUAN";
    private static Constructor<? extends Log> logConstructor;

    private LogFactory() {
    }

    public static Log getLog(Class<?> aClass) {
        return LogFactory.getLog(aClass.getName());
    }

    public static Log getLog(String logger) {
        try {
            return logConstructor.newInstance(logger);
        }
        catch (Throwable t) {
            throw new LogException("Error creating logger for logger " + logger + ".  Cause: " + t, t);
        }
    }

    public static synchronized void useCustomLogging(Class<? extends Log> clazz) {
        LogFactory.setImplementation(clazz);
    }

    public static synchronized void useSlf4jLogging() {
        LogFactory.setImplementation(Slf4jLoggerImpl.class);
    }

    public static synchronized void useLog4JLogging() {
        LogFactory.setImplementation(Log4jImpl.class);
    }

    private static void tryImplementation(Runnable runnable) {
        if (logConstructor == null) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void setImplementation(Class<? extends Log> implClass) {
        try {
            Constructor<? extends Log> candidate = implClass.getConstructor(String.class);
            Log log = candidate.newInstance(LogFactory.class.getName());
            log.debug("Logging initialized using '" + implClass + "' adapter.");
            logConstructor = candidate;
        }
        catch (Throwable t) {
            throw new LogException("Error setting Log implementation.  Cause: " + t, t);
        }
    }

    static {
        LogFactory.tryImplementation(new Runnable(){

            @Override
            public void run() {
                LogFactory.useSlf4jLogging();
            }
        });
        LogFactory.tryImplementation(new Runnable(){

            @Override
            public void run() {
                LogFactory.useLog4JLogging();
            }
        });
    }
}

