/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions;

import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedLong;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.text.DecimalFormat;
import java.util.Locale;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.immutables.FluentCompareTo;
import org.xrpl.xrpl4j.model.immutables.Wrapped;
import org.xrpl.xrpl4j.model.immutables.Wrapper;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.CurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.Marker;
import org.xrpl.xrpl4j.model.transactions.XAddress;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

public class Wrappers {

    @JsonSerialize(as=Marker.class)
    @JsonDeserialize(as=Marker.class)
    @Value.Immutable
    @Wrapped
    static abstract class _Marker
    extends Wrapper<String>
    implements Serializable {
        _Marker() {
        }

        @Override
        @JsonRawValue
        public String toString() {
            return (String)this.value();
        }
    }

    @JsonSerialize(as=XrpCurrencyAmount.class)
    @JsonDeserialize(as=XrpCurrencyAmount.class)
    @Value.Immutable(intern=true)
    @Wrapped
    static abstract class _XrpCurrencyAmount
    extends Wrapper<UnsignedLong>
    implements Serializable,
    CurrencyAmount {
        static final long ONE_XRP_IN_DROPS = 1000000L;
        static final long MAX_XRP = 100000000000L;
        static final long MAX_XRP_IN_DROPS = 100000000000000000L;
        static final BigDecimal SMALLEST_XRP = new BigDecimal("0.000001");
        static final DecimalFormat FORMATTER = new DecimalFormat("###,###");

        _XrpCurrencyAmount() {
        }

        public static XrpCurrencyAmount ofDrops(long drops) {
            return _XrpCurrencyAmount.ofDrops(UnsignedLong.valueOf((long)drops));
        }

        public static XrpCurrencyAmount ofDrops(UnsignedLong drops) {
            return XrpCurrencyAmount.of(drops);
        }

        public static XrpCurrencyAmount ofXrp(BigDecimal amount) {
            if (FluentCompareTo.is(amount).notEqualTo(BigDecimal.ZERO)) {
                Preconditions.checkArgument((boolean)FluentCompareTo.is(amount).greaterThanEqualTo(SMALLEST_XRP));
            }
            return _XrpCurrencyAmount.ofDrops(UnsignedLong.valueOf((BigInteger)amount.scaleByPowerOfTen(6).toBigIntegerExact()));
        }

        public BigDecimal toXrp() {
            return new BigDecimal(((UnsignedLong)this.value()).bigIntegerValue()).divide(BigDecimal.valueOf(1000000L), MathContext.DECIMAL128);
        }

        public XrpCurrencyAmount plus(XrpCurrencyAmount other) {
            return XrpCurrencyAmount.of(((UnsignedLong)this.value()).plus(other.value()));
        }

        public XrpCurrencyAmount minus(XrpCurrencyAmount other) {
            return XrpCurrencyAmount.of(((UnsignedLong)this.value()).minus(other.value()));
        }

        public XrpCurrencyAmount times(XrpCurrencyAmount other) {
            return XrpCurrencyAmount.of(((UnsignedLong)this.value()).times(other.value()));
        }

        @Override
        public String toString() {
            return ((UnsignedLong)this.value()).toString();
        }

        @Value.Check
        protected void check() {
            Preconditions.checkState((boolean)FluentCompareTo.is((UnsignedLong)this.value()).lessThanOrEqualTo(UnsignedLong.valueOf((long)100000000000000000L)), (Object)String.format("XRP Amounts may not exceed %s drops (100B XRP, denominated in Drops)", FORMATTER.format(100000000000000000L)));
        }
    }

    @JsonSerialize(as=Hash256.class)
    @JsonDeserialize(as=Hash256.class)
    @Value.Immutable
    @Wrapped
    static abstract class _Hash256
    extends Wrapper<String>
    implements Serializable {
        _Hash256() {
        }

        @Override
        public String toString() {
            return (String)this.value();
        }

        @Value.Check
        public void validateLength() {
            Preconditions.checkArgument((((String)this.value()).length() == 64 ? 1 : 0) != 0, (Object)"Hash256 Strings must be 64 characters long.");
        }

        @Override
        public boolean equals(Object obj) {
            String otherValue;
            if (obj != null && obj instanceof Hash256 && (otherValue = ((Hash256)obj).value()) != null) {
                return otherValue.toUpperCase(Locale.ENGLISH).equals(((String)this.value()).toUpperCase(Locale.ENGLISH));
            }
            return false;
        }

        @Override
        public int hashCode() {
            return ((String)this.value()).toUpperCase(Locale.ENGLISH).hashCode();
        }
    }

    @JsonSerialize(as=XAddress.class)
    @JsonDeserialize(as=XAddress.class)
    @Value.Immutable(intern=true)
    @Wrapped
    static abstract class _XAddress
    extends Wrapper<String>
    implements Serializable {
        _XAddress() {
        }

        @Override
        public String toString() {
            return (String)this.value();
        }
    }

    @JsonSerialize(as=Address.class)
    @JsonDeserialize(as=Address.class)
    @Value.Immutable(intern=true)
    @Wrapped
    static abstract class _Address
    extends Wrapper<String>
    implements Serializable {
        _Address() {
        }

        @Override
        public String toString() {
            return (String)this.value();
        }
    }
}

