/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.transactions.Memo;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Memo", generator="Immutables")
@Immutable
public final class ImmutableMemo
implements Memo {
    @Nullable
    private final String memoData;
    @Nullable
    private final String memoFormat;
    @Nullable
    private final String memoType;

    private ImmutableMemo(@Nullable String memoData, @Nullable String memoFormat, @Nullable String memoType) {
        this.memoData = memoData;
        this.memoFormat = memoFormat;
        this.memoType = memoType;
    }

    @Override
    @JsonProperty(value="MemoData")
    public Optional<String> memoData() {
        return Optional.ofNullable(this.memoData);
    }

    @Override
    @JsonProperty(value="MemoFormat")
    public Optional<String> memoFormat() {
        return Optional.ofNullable(this.memoFormat);
    }

    @Override
    @JsonProperty(value="MemoType")
    public Optional<String> memoType() {
        return Optional.ofNullable(this.memoType);
    }

    public final ImmutableMemo withMemoData(String value) {
        String newValue = Objects.requireNonNull(value, "memoData");
        if (Objects.equals(this.memoData, newValue)) {
            return this;
        }
        return new ImmutableMemo(newValue, this.memoFormat, this.memoType);
    }

    public final ImmutableMemo withMemoData(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.memoData, value)) {
            return this;
        }
        return new ImmutableMemo(value, this.memoFormat, this.memoType);
    }

    public final ImmutableMemo withMemoFormat(String value) {
        String newValue = Objects.requireNonNull(value, "memoFormat");
        if (Objects.equals(this.memoFormat, newValue)) {
            return this;
        }
        return new ImmutableMemo(this.memoData, newValue, this.memoType);
    }

    public final ImmutableMemo withMemoFormat(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.memoFormat, value)) {
            return this;
        }
        return new ImmutableMemo(this.memoData, value, this.memoType);
    }

    public final ImmutableMemo withMemoType(String value) {
        String newValue = Objects.requireNonNull(value, "memoType");
        if (Objects.equals(this.memoType, newValue)) {
            return this;
        }
        return new ImmutableMemo(this.memoData, this.memoFormat, newValue);
    }

    public final ImmutableMemo withMemoType(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.memoType, value)) {
            return this;
        }
        return new ImmutableMemo(this.memoData, this.memoFormat, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMemo && this.equalTo((ImmutableMemo)another);
    }

    private boolean equalTo(ImmutableMemo another) {
        return Objects.equals(this.memoData, another.memoData) && Objects.equals(this.memoFormat, another.memoFormat) && Objects.equals(this.memoType, another.memoType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.memoData);
        h += (h << 5) + Objects.hashCode(this.memoFormat);
        h += (h << 5) + Objects.hashCode(this.memoType);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Memo").omitNullValues().add("memoData", (Object)this.memoData).add("memoFormat", (Object)this.memoFormat).add("memoType", (Object)this.memoType).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMemo fromJson(Json json) {
        Builder builder = ImmutableMemo.builder();
        if (json.memoData != null) {
            builder.memoData(json.memoData);
        }
        if (json.memoFormat != null) {
            builder.memoFormat(json.memoFormat);
        }
        if (json.memoType != null) {
            builder.memoType(json.memoType);
        }
        return builder.build();
    }

    public static ImmutableMemo copyOf(Memo instance) {
        if (instance instanceof ImmutableMemo) {
            return (ImmutableMemo)instance;
        }
        return ImmutableMemo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Memo", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String memoData;
        @Nullable
        private String memoFormat;
        @Nullable
        private String memoType;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Memo instance) {
            Optional<String> memoTypeOptional;
            Optional<String> memoFormatOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> memoDataOptional = instance.memoData();
            if (memoDataOptional.isPresent()) {
                this.memoData(memoDataOptional);
            }
            if ((memoFormatOptional = instance.memoFormat()).isPresent()) {
                this.memoFormat(memoFormatOptional);
            }
            if ((memoTypeOptional = instance.memoType()).isPresent()) {
                this.memoType(memoTypeOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder memoData(String memoData) {
            this.memoData = Objects.requireNonNull(memoData, "memoData");
            return this;
        }

        @JsonProperty(value="MemoData")
        @CanIgnoreReturnValue
        public final Builder memoData(Optional<String> memoData) {
            this.memoData = memoData.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder memoFormat(String memoFormat) {
            this.memoFormat = Objects.requireNonNull(memoFormat, "memoFormat");
            return this;
        }

        @JsonProperty(value="MemoFormat")
        @CanIgnoreReturnValue
        public final Builder memoFormat(Optional<String> memoFormat) {
            this.memoFormat = memoFormat.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder memoType(String memoType) {
            this.memoType = Objects.requireNonNull(memoType, "memoType");
            return this;
        }

        @JsonProperty(value="MemoType")
        @CanIgnoreReturnValue
        public final Builder memoType(Optional<String> memoType) {
            this.memoType = memoType.orElse(null);
            return this;
        }

        public ImmutableMemo build() {
            return new ImmutableMemo(this.memoData, this.memoFormat, this.memoType);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Memo", generator="Immutables")
    static final class Json
    implements Memo {
        @Nullable
        Optional<String> memoData = Optional.empty();
        @Nullable
        Optional<String> memoFormat = Optional.empty();
        @Nullable
        Optional<String> memoType = Optional.empty();

        Json() {
        }

        @JsonProperty(value="MemoData")
        public void setMemoData(Optional<String> memoData) {
            this.memoData = memoData;
        }

        @JsonProperty(value="MemoFormat")
        public void setMemoFormat(Optional<String> memoFormat) {
            this.memoFormat = memoFormat;
        }

        @JsonProperty(value="MemoType")
        public void setMemoType(Optional<String> memoType) {
            this.memoType = memoType;
        }

        @Override
        public Optional<String> memoData() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> memoFormat() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> memoType() {
            throw new UnsupportedOperationException();
        }
    }
}

