/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.IssuedCurrencyAmount;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="IssuedCurrencyAmount", generator="Immutables")
@Immutable
public final class ImmutableIssuedCurrencyAmount
implements IssuedCurrencyAmount {
    private final String value;
    private final String currency;
    private final Address issuer;

    private ImmutableIssuedCurrencyAmount(String value, String currency, Address issuer) {
        this.value = value;
        this.currency = currency;
        this.issuer = issuer;
    }

    @Override
    @JsonProperty(value="value")
    public String value() {
        return this.value;
    }

    @Override
    @JsonProperty(value="currency")
    public String currency() {
        return this.currency;
    }

    @Override
    @JsonProperty(value="issuer")
    public Address issuer() {
        return this.issuer;
    }

    public final ImmutableIssuedCurrencyAmount withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableIssuedCurrencyAmount(newValue, this.currency, this.issuer);
    }

    public final ImmutableIssuedCurrencyAmount withCurrency(String value) {
        String newValue = Objects.requireNonNull(value, "currency");
        if (this.currency.equals(newValue)) {
            return this;
        }
        return new ImmutableIssuedCurrencyAmount(this.value, newValue, this.issuer);
    }

    public final ImmutableIssuedCurrencyAmount withIssuer(Address value) {
        if (this.issuer == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "issuer");
        return new ImmutableIssuedCurrencyAmount(this.value, this.currency, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIssuedCurrencyAmount && this.equalTo((ImmutableIssuedCurrencyAmount)another);
    }

    private boolean equalTo(ImmutableIssuedCurrencyAmount another) {
        return this.value.equals(another.value) && this.currency.equals(another.currency) && this.issuer.equals(another.issuer);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + this.currency.hashCode();
        h += (h << 5) + this.issuer.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"IssuedCurrencyAmount").omitNullValues().add("value", (Object)this.value).add("currency", (Object)this.currency).add("issuer", (Object)this.issuer).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableIssuedCurrencyAmount fromJson(Json json) {
        Builder builder = ImmutableIssuedCurrencyAmount.builder();
        if (json.value != null) {
            builder.value(json.value);
        }
        if (json.currency != null) {
            builder.currency(json.currency);
        }
        if (json.issuer != null) {
            builder.issuer(json.issuer);
        }
        return builder.build();
    }

    public static ImmutableIssuedCurrencyAmount copyOf(IssuedCurrencyAmount instance) {
        if (instance instanceof ImmutableIssuedCurrencyAmount) {
            return (ImmutableIssuedCurrencyAmount)instance;
        }
        return ImmutableIssuedCurrencyAmount.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="IssuedCurrencyAmount", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private static final long INIT_BIT_CURRENCY = 2L;
        private static final long INIT_BIT_ISSUER = 4L;
        private long initBits = 7L;
        @Nullable
        private String value;
        @Nullable
        private String currency;
        @Nullable
        private Address issuer;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(IssuedCurrencyAmount instance) {
            Objects.requireNonNull(instance, "instance");
            this.value(instance.value());
            this.currency(instance.currency());
            this.issuer(instance.issuer());
            return this;
        }

        @JsonProperty(value="value")
        @CanIgnoreReturnValue
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="currency")
        @CanIgnoreReturnValue
        public final Builder currency(String currency) {
            this.currency = Objects.requireNonNull(currency, "currency");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="issuer")
        @CanIgnoreReturnValue
        public final Builder issuer(Address issuer) {
            this.issuer = Objects.requireNonNull(issuer, "issuer");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableIssuedCurrencyAmount build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableIssuedCurrencyAmount(this.value, this.currency, this.issuer);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("currency");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("issuer");
            }
            return "Cannot build IssuedCurrencyAmount, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="IssuedCurrencyAmount", generator="Immutables")
    static final class Json
    implements IssuedCurrencyAmount {
        @Nullable
        String value;
        @Nullable
        String currency;
        @Nullable
        Address issuer;

        Json() {
        }

        @JsonProperty(value="value")
        public void setValue(String value) {
            this.value = value;
        }

        @JsonProperty(value="currency")
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @JsonProperty(value="issuer")
        public void setIssuer(Address issuer) {
            this.issuer = issuer;
        }

        @Override
        public String value() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String currency() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address issuer() {
            throw new UnsupportedOperationException();
        }
    }
}

