/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import com.ripple.cryptoconditions.Condition;
import com.ripple.cryptoconditions.Fulfillment;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.immutables.FluentCompareTo;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.ImmutableEscrowFinish;
import org.xrpl.xrpl4j.model.transactions.Transaction;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

@JsonSerialize(as=ImmutableEscrowFinish.class)
@JsonDeserialize(as=ImmutableEscrowFinish.class)
@Value.Immutable
public interface EscrowFinish
extends Transaction {
    public static ImmutableEscrowFinish.Builder builder() {
        return ImmutableEscrowFinish.builder();
    }

    public static XrpCurrencyAmount computeFee(XrpCurrencyAmount currentLedgerFeeDrops, Fulfillment fulfillment) {
        Objects.requireNonNull(currentLedgerFeeDrops);
        Objects.requireNonNull(fulfillment);
        UnsignedLong newFee = currentLedgerFeeDrops.value().plus(UnsignedLong.valueOf((long)320L)).plus(UnsignedLong.valueOf((long)(10L * (fulfillment.getDerivedCondition().getCost() / 16L))));
        return XrpCurrencyAmount.of(newFee);
    }

    @JsonProperty(value="Flags")
    @Value.Derived
    default public Flags.TransactionFlags flags() {
        return new Flags.TransactionFlags.Builder().tfFullyCanonicalSig(true).build();
    }

    @JsonProperty(value="Owner")
    public Address owner();

    @JsonProperty(value="OfferSequence")
    public UnsignedInteger offerSequence();

    @JsonProperty(value="Condition")
    public Optional<Condition> condition();

    @JsonProperty(value="Fulfillment")
    public Optional<Fulfillment<?>> fulfillment();

    @Value.Check
    default public void check() {
        this.fulfillment().ifPresent(f -> {
            UnsignedLong feeInDrops = this.fee().value();
            Preconditions.checkState((boolean)this.condition().isPresent(), (Object)"If a fulfillment is specified, the corresponding condition must also be specified.");
            Preconditions.checkState((boolean)FluentCompareTo.is(feeInDrops).greaterThanEqualTo(UnsignedLong.valueOf((long)330L)), (Object)"If a fulfillment is specified, the fee must be set to 330 or greater.");
        });
        this.condition().ifPresent($ -> Preconditions.checkState((boolean)this.fulfillment().isPresent(), (Object)"If a condition is specified, the corresponding fulfillment must also be specified."));
    }
}

