/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.ImmutableDepositPreAuth;
import org.xrpl.xrpl4j.model.transactions.Transaction;

@JsonSerialize(as=ImmutableDepositPreAuth.class)
@JsonDeserialize(as=ImmutableDepositPreAuth.class)
@Value.Immutable
public interface DepositPreAuth
extends Transaction {
    public static ImmutableDepositPreAuth.Builder builder() {
        return ImmutableDepositPreAuth.builder();
    }

    @JsonProperty(value="Flags")
    @Value.Derived
    default public Flags.TransactionFlags flags() {
        return new Flags.TransactionFlags.Builder().tfFullyCanonicalSig(true).build();
    }

    @JsonProperty(value="Authorize")
    public Optional<Address> authorize();

    @JsonProperty(value="Unauthorize")
    public Optional<Address> unauthorize();

    @Value.Check
    default public void validateFieldPresence() {
        Preconditions.checkArgument((!(!this.authorize().isPresent() && !this.unauthorize().isPresent() || this.authorize().isPresent() && this.unauthorize().isPresent()) ? 1 : 0) != 0, (Object)"The DepositPreAuth transaction must include either Authorize or Unauthorize, but not both.");
    }
}

