/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.ledger.LedgerObject;
import org.xrpl.xrpl4j.model.ledger.SignerEntryWrapper;
import org.xrpl.xrpl4j.model.ledger.SignerListObject;
import org.xrpl.xrpl4j.model.transactions.Hash256;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SignerListObject", generator="Immutables")
@Immutable
public final class ImmutableSignerListObject
implements SignerListObject {
    private final transient LedgerObject.LedgerEntryType ledgerEntryType;
    private final Flags.SignerListFlags flags;
    private final Hash256 previousTransactionId;
    private final UnsignedInteger previousTransactionLedgerSequence;
    private final String ownerNode;
    private final UnsignedInteger signerListId;
    private final UnsignedInteger signerQuorum;
    private final ImmutableList<SignerEntryWrapper> signerEntries;
    private final Hash256 index;

    private ImmutableSignerListObject(Flags.SignerListFlags flags, Hash256 previousTransactionId, UnsignedInteger previousTransactionLedgerSequence, String ownerNode, UnsignedInteger signerListId, UnsignedInteger signerQuorum, ImmutableList<SignerEntryWrapper> signerEntries, Hash256 index) {
        this.flags = flags;
        this.previousTransactionId = previousTransactionId;
        this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        this.ownerNode = ownerNode;
        this.signerListId = signerListId;
        this.signerQuorum = signerQuorum;
        this.signerEntries = signerEntries;
        this.index = index;
        this.ledgerEntryType = Objects.requireNonNull(SignerListObject.super.ledgerEntryType(), "ledgerEntryType");
    }

    @Override
    @JsonProperty(value="LedgerEntryType")
    public LedgerObject.LedgerEntryType ledgerEntryType() {
        return this.ledgerEntryType;
    }

    @Override
    @JsonProperty(value="Flags")
    public Flags.SignerListFlags flags() {
        return this.flags;
    }

    @Override
    @JsonProperty(value="PreviousTxnID")
    public Hash256 previousTransactionId() {
        return this.previousTransactionId;
    }

    @Override
    @JsonProperty(value="PreviousTxnLgrSeq")
    public UnsignedInteger previousTransactionLedgerSequence() {
        return this.previousTransactionLedgerSequence;
    }

    @Override
    @JsonProperty(value="OwnerNode")
    public String ownerNode() {
        return this.ownerNode;
    }

    @Override
    @JsonProperty(value="SignerListID")
    public UnsignedInteger signerListId() {
        return this.signerListId;
    }

    @Override
    @JsonProperty(value="SignerQuorum")
    public UnsignedInteger signerQuorum() {
        return this.signerQuorum;
    }

    @JsonProperty(value="SignerEntries")
    public ImmutableList<SignerEntryWrapper> signerEntries() {
        return this.signerEntries;
    }

    @Override
    @JsonProperty(value="index")
    public Hash256 index() {
        return this.index;
    }

    public final ImmutableSignerListObject withFlags(Flags.SignerListFlags value) {
        if (this.flags == value) {
            return this;
        }
        Flags.SignerListFlags newValue = Objects.requireNonNull(value, "flags");
        return new ImmutableSignerListObject(newValue, this.previousTransactionId, this.previousTransactionLedgerSequence, this.ownerNode, this.signerListId, this.signerQuorum, this.signerEntries, this.index);
    }

    public final ImmutableSignerListObject withPreviousTransactionId(Hash256 value) {
        if (this.previousTransactionId == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "previousTransactionId");
        return new ImmutableSignerListObject(this.flags, newValue, this.previousTransactionLedgerSequence, this.ownerNode, this.signerListId, this.signerQuorum, this.signerEntries, this.index);
    }

    public final ImmutableSignerListObject withPreviousTransactionLedgerSequence(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "previousTransactionLedgerSequence");
        if (this.previousTransactionLedgerSequence.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableSignerListObject(this.flags, this.previousTransactionId, newValue, this.ownerNode, this.signerListId, this.signerQuorum, this.signerEntries, this.index);
    }

    public final ImmutableSignerListObject withOwnerNode(String value) {
        String newValue = Objects.requireNonNull(value, "ownerNode");
        if (this.ownerNode.equals(newValue)) {
            return this;
        }
        return new ImmutableSignerListObject(this.flags, this.previousTransactionId, this.previousTransactionLedgerSequence, newValue, this.signerListId, this.signerQuorum, this.signerEntries, this.index);
    }

    public final ImmutableSignerListObject withSignerListId(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "signerListId");
        if (this.signerListId.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableSignerListObject(this.flags, this.previousTransactionId, this.previousTransactionLedgerSequence, this.ownerNode, newValue, this.signerQuorum, this.signerEntries, this.index);
    }

    public final ImmutableSignerListObject withSignerQuorum(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "signerQuorum");
        if (this.signerQuorum.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableSignerListObject(this.flags, this.previousTransactionId, this.previousTransactionLedgerSequence, this.ownerNode, this.signerListId, newValue, this.signerEntries, this.index);
    }

    public final ImmutableSignerListObject withSignerEntries(SignerEntryWrapper ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableSignerListObject(this.flags, this.previousTransactionId, this.previousTransactionLedgerSequence, this.ownerNode, this.signerListId, this.signerQuorum, (ImmutableList<SignerEntryWrapper>)newValue, this.index);
    }

    public final ImmutableSignerListObject withSignerEntries(Iterable<? extends SignerEntryWrapper> elements) {
        if (this.signerEntries == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableSignerListObject(this.flags, this.previousTransactionId, this.previousTransactionLedgerSequence, this.ownerNode, this.signerListId, this.signerQuorum, (ImmutableList<SignerEntryWrapper>)newValue, this.index);
    }

    public final ImmutableSignerListObject withIndex(Hash256 value) {
        if (this.index == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "index");
        return new ImmutableSignerListObject(this.flags, this.previousTransactionId, this.previousTransactionLedgerSequence, this.ownerNode, this.signerListId, this.signerQuorum, this.signerEntries, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSignerListObject && this.equalTo((ImmutableSignerListObject)another);
    }

    private boolean equalTo(ImmutableSignerListObject another) {
        return this.ledgerEntryType.equals((Object)another.ledgerEntryType) && this.flags.equals(another.flags) && this.previousTransactionId.equals(another.previousTransactionId) && this.previousTransactionLedgerSequence.equals((Object)another.previousTransactionLedgerSequence) && this.ownerNode.equals(another.ownerNode) && this.signerListId.equals((Object)another.signerListId) && this.signerQuorum.equals((Object)another.signerQuorum) && this.signerEntries.equals(another.signerEntries) && this.index.equals(another.index);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.ledgerEntryType.hashCode();
        h += (h << 5) + this.flags.hashCode();
        h += (h << 5) + this.previousTransactionId.hashCode();
        h += (h << 5) + this.previousTransactionLedgerSequence.hashCode();
        h += (h << 5) + this.ownerNode.hashCode();
        h += (h << 5) + this.signerListId.hashCode();
        h += (h << 5) + this.signerQuorum.hashCode();
        h += (h << 5) + this.signerEntries.hashCode();
        h += (h << 5) + this.index.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SignerListObject").omitNullValues().add("ledgerEntryType", (Object)this.ledgerEntryType).add("flags", (Object)this.flags).add("previousTransactionId", (Object)this.previousTransactionId).add("previousTransactionLedgerSequence", (Object)this.previousTransactionLedgerSequence).add("ownerNode", (Object)this.ownerNode).add("signerListId", (Object)this.signerListId).add("signerQuorum", (Object)this.signerQuorum).add("signerEntries", this.signerEntries).add("index", (Object)this.index).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSignerListObject fromJson(Json json) {
        Builder builder = ImmutableSignerListObject.builder();
        if (json.flags != null) {
            builder.flags(json.flags);
        }
        if (json.previousTransactionId != null) {
            builder.previousTransactionId(json.previousTransactionId);
        }
        if (json.previousTransactionLedgerSequence != null) {
            builder.previousTransactionLedgerSequence(json.previousTransactionLedgerSequence);
        }
        if (json.ownerNode != null) {
            builder.ownerNode(json.ownerNode);
        }
        if (json.signerListId != null) {
            builder.signerListId(json.signerListId);
        }
        if (json.signerQuorum != null) {
            builder.signerQuorum(json.signerQuorum);
        }
        if (json.signerEntries != null) {
            builder.addAllSignerEntries(json.signerEntries);
        }
        if (json.index != null) {
            builder.index(json.index);
        }
        return builder.build();
    }

    public static ImmutableSignerListObject copyOf(SignerListObject instance) {
        if (instance instanceof ImmutableSignerListObject) {
            return (ImmutableSignerListObject)instance;
        }
        return ImmutableSignerListObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SignerListObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_FLAGS = 1L;
        private static final long INIT_BIT_PREVIOUS_TRANSACTION_ID = 2L;
        private static final long INIT_BIT_PREVIOUS_TRANSACTION_LEDGER_SEQUENCE = 4L;
        private static final long INIT_BIT_OWNER_NODE = 8L;
        private static final long INIT_BIT_SIGNER_LIST_ID = 16L;
        private static final long INIT_BIT_SIGNER_QUORUM = 32L;
        private static final long INIT_BIT_INDEX = 64L;
        private long initBits = 127L;
        @Nullable
        private Flags.SignerListFlags flags;
        @Nullable
        private Hash256 previousTransactionId;
        @Nullable
        private UnsignedInteger previousTransactionLedgerSequence;
        @Nullable
        private String ownerNode;
        @Nullable
        private UnsignedInteger signerListId;
        @Nullable
        private UnsignedInteger signerQuorum;
        private ImmutableList.Builder<SignerEntryWrapper> signerEntries = ImmutableList.builder();
        @Nullable
        private Hash256 index;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SignerListObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.flags(instance.flags());
            this.previousTransactionId(instance.previousTransactionId());
            this.previousTransactionLedgerSequence(instance.previousTransactionLedgerSequence());
            this.ownerNode(instance.ownerNode());
            this.signerListId(instance.signerListId());
            this.signerQuorum(instance.signerQuorum());
            this.addAllSignerEntries(instance.signerEntries());
            this.index(instance.index());
            return this;
        }

        @JsonProperty(value="Flags")
        @CanIgnoreReturnValue
        public final Builder flags(Flags.SignerListFlags flags) {
            this.flags = Objects.requireNonNull(flags, "flags");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="PreviousTxnID")
        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Hash256 previousTransactionId) {
            this.previousTransactionId = Objects.requireNonNull(previousTransactionId, "previousTransactionId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(UnsignedInteger previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = Objects.requireNonNull(previousTransactionLedgerSequence, "previousTransactionLedgerSequence");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="OwnerNode")
        @CanIgnoreReturnValue
        public final Builder ownerNode(String ownerNode) {
            this.ownerNode = Objects.requireNonNull(ownerNode, "ownerNode");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="SignerListID")
        @CanIgnoreReturnValue
        public final Builder signerListId(UnsignedInteger signerListId) {
            this.signerListId = Objects.requireNonNull(signerListId, "signerListId");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="SignerQuorum")
        @CanIgnoreReturnValue
        public final Builder signerQuorum(UnsignedInteger signerQuorum) {
            this.signerQuorum = Objects.requireNonNull(signerQuorum, "signerQuorum");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSignerEntries(SignerEntryWrapper element) {
            this.signerEntries.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSignerEntries(SignerEntryWrapper ... elements) {
            this.signerEntries.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="SignerEntries")
        @CanIgnoreReturnValue
        public final Builder signerEntries(Iterable<? extends SignerEntryWrapper> elements) {
            this.signerEntries = ImmutableList.builder();
            return this.addAllSignerEntries(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSignerEntries(Iterable<? extends SignerEntryWrapper> elements) {
            this.signerEntries.addAll(elements);
            return this;
        }

        @JsonProperty(value="index")
        @CanIgnoreReturnValue
        public final Builder index(Hash256 index) {
            this.index = Objects.requireNonNull(index, "index");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public ImmutableSignerListObject build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSignerListObject(this.flags, this.previousTransactionId, this.previousTransactionLedgerSequence, this.ownerNode, this.signerListId, this.signerQuorum, this.signerEntries.build(), this.index);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("flags");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("previousTransactionId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("previousTransactionLedgerSequence");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("ownerNode");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("signerListId");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("signerQuorum");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("index");
            }
            return "Cannot build SignerListObject, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SignerListObject", generator="Immutables")
    static final class Json
    implements SignerListObject {
        @Nullable
        Flags.SignerListFlags flags;
        @Nullable
        Hash256 previousTransactionId;
        @Nullable
        UnsignedInteger previousTransactionLedgerSequence;
        @Nullable
        String ownerNode;
        @Nullable
        UnsignedInteger signerListId;
        @Nullable
        UnsignedInteger signerQuorum;
        @Nullable
        List<SignerEntryWrapper> signerEntries = ImmutableList.of();
        @Nullable
        Hash256 index;

        Json() {
        }

        @JsonProperty(value="Flags")
        public void setFlags(Flags.SignerListFlags flags) {
            this.flags = flags;
        }

        @JsonProperty(value="PreviousTxnID")
        public void setPreviousTransactionId(Hash256 previousTransactionId) {
            this.previousTransactionId = previousTransactionId;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        public void setPreviousTransactionLedgerSequence(UnsignedInteger previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        }

        @JsonProperty(value="OwnerNode")
        public void setOwnerNode(String ownerNode) {
            this.ownerNode = ownerNode;
        }

        @JsonProperty(value="SignerListID")
        public void setSignerListId(UnsignedInteger signerListId) {
            this.signerListId = signerListId;
        }

        @JsonProperty(value="SignerQuorum")
        public void setSignerQuorum(UnsignedInteger signerQuorum) {
            this.signerQuorum = signerQuorum;
        }

        @JsonProperty(value="SignerEntries")
        public void setSignerEntries(List<SignerEntryWrapper> signerEntries) {
            this.signerEntries = signerEntries;
        }

        @JsonProperty(value="index")
        public void setIndex(Hash256 index) {
            this.index = index;
        }

        @Override
        @JsonIgnore
        public LedgerObject.LedgerEntryType ledgerEntryType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Flags.SignerListFlags flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 previousTransactionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger previousTransactionLedgerSequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String ownerNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger signerListId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger signerQuorum() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SignerEntryWrapper> signerEntries() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 index() {
            throw new UnsupportedOperationException();
        }
    }
}

