/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import com.ripple.cryptoconditions.Condition;
import java.util.Optional;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.ledger.ImmutableEscrowObject;
import org.xrpl.xrpl4j.model.ledger.LedgerObject;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

@JsonSerialize(as=ImmutableEscrowObject.class)
@JsonDeserialize(as=ImmutableEscrowObject.class)
@Value.Immutable
public interface EscrowObject
extends LedgerObject {
    public static ImmutableEscrowObject.Builder builder() {
        return ImmutableEscrowObject.builder();
    }

    @JsonProperty(value="LedgerEntryType")
    @Value.Derived
    default public LedgerObject.LedgerEntryType ledgerEntryType() {
        return LedgerObject.LedgerEntryType.ESCROW;
    }

    @JsonProperty(value="Account")
    public Address account();

    @JsonProperty(value="Destination")
    public Address destination();

    @JsonProperty(value="Amount")
    public XrpCurrencyAmount amount();

    @JsonProperty(value="Condition")
    public Optional<Condition> condition();

    @JsonProperty(value="CancelAfter")
    public Optional<UnsignedLong> cancelAfter();

    @JsonProperty(value="FinishAfter")
    public Optional<UnsignedLong> finishAfter();

    @JsonProperty(value="Flags")
    @Value.Derived
    default public Flags flags() {
        return Flags.UNSET;
    }

    @JsonProperty(value="SourceTag")
    public Optional<UnsignedInteger> sourceTag();

    @JsonProperty(value="DestinationTag")
    public Optional<UnsignedInteger> destinationTag();

    @JsonProperty(value="OwnerNode")
    public Optional<String> ownerNode();

    @JsonProperty(value="DestinationNode")
    public Optional<String> destinationNode();

    @JsonProperty(value="PreviousTxnID")
    public Optional<Hash256> previousTransactionId();

    @JsonProperty(value="PreviousTxnLgrSeq")
    public Optional<UnsignedInteger> previousTransactionLedgerSequence();

    public Hash256 index();
}

