/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.jackson.modules;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;

public class LedgerIndexSerializer
extends StdScalarSerializer<LedgerIndex> {
    public LedgerIndexSerializer() {
        super(LedgerIndex.class, false);
    }

    public void serialize(LedgerIndex ledgerIndex, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (this.isInteger(ledgerIndex)) {
            gen.writeNumber(ledgerIndex.unsignedIntegerValue().intValue());
        } else {
            gen.writeString(ledgerIndex.value());
        }
    }

    private boolean isInteger(LedgerIndex value) {
        try {
            Integer.parseInt(value.value());
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

