/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.transactions;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.primitives.UnsignedLong;
import java.util.Optional;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.client.XrplRequestParams;
import org.xrpl.xrpl4j.model.client.transactions.ImmutableTransactionRequestParams;
import org.xrpl.xrpl4j.model.transactions.Hash256;

@JsonSerialize(as=ImmutableTransactionRequestParams.class)
@JsonDeserialize(as=ImmutableTransactionRequestParams.class)
@Value.Immutable
public interface TransactionRequestParams
extends XrplRequestParams {
    public static ImmutableTransactionRequestParams.Builder builder() {
        return ImmutableTransactionRequestParams.builder();
    }

    public static TransactionRequestParams of(Hash256 transactionHash) {
        return TransactionRequestParams.builder().transaction(transactionHash).build();
    }

    public Hash256 transaction();

    @Value.Derived
    default public boolean binary() {
        return false;
    }

    @JsonProperty(value="min_ledger")
    public Optional<UnsignedLong> minLedger();

    @JsonProperty(value="max_ledger")
    public Optional<UnsignedLong> maxLedger();
}

