/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.transactions;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import java.util.Arrays;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.client.transactions.ImmutableSignedTransaction;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.Transaction;

@JsonSerialize(as=ImmutableSignedTransaction.class)
@JsonDeserialize(as=ImmutableSignedTransaction.class)
@Deprecated
@Value.Immutable
public interface SignedTransaction<T extends Transaction> {
    public static final String SIGNED_TRANSACTION_HASH_PREFIX = "54584E00";

    public static <T extends Transaction> ImmutableSignedTransaction.Builder<T> builder() {
        return ImmutableSignedTransaction.builder();
    }

    public T signedTransaction();

    public String signedTransactionBlob();

    @Value.Derived
    default public Hash256 hash() {
        byte[] hashBytes = Arrays.copyOfRange(Hashing.sha512().hashBytes(BaseEncoding.base16().decode((CharSequence)SIGNED_TRANSACTION_HASH_PREFIX.concat(this.signedTransactionBlob().toUpperCase()))).asBytes(), 0, 32);
        return Hash256.of(BaseEncoding.base16().encode(hashBytes));
    }
}

